/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import java.util.Locale;
import java.util.Objects;

@ThriftStruct
public final class CatalogSchemaName {
    private final String catalogName;
    private final String schemaName;

    @ThriftConstructor
    public CatalogSchemaName(String catalogName, String schemaName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null").toLowerCase(Locale.ENGLISH);
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null").toLowerCase(Locale.ENGLISH);
    }

    @ThriftField(value=1)
    public String getCatalogName() {
        return this.catalogName;
    }

    @ThriftField(value=2)
    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogSchemaName that = (CatalogSchemaName)obj;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaName, that.schemaName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName);
    }

    public String toString() {
        return this.catalogName + '.' + this.schemaName;
    }
}

