/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.spi.statistics.PlanStatistics;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public class HistoricalPlanStatisticsEntry {
    private final PlanStatistics planStatistics;
    private final List<PlanStatistics> inputTableStatistics;

    @ThriftConstructor
    public HistoricalPlanStatisticsEntry(PlanStatistics planStatistics, List<PlanStatistics> inputTableStatistics) {
        this.planStatistics = planStatistics == null ? PlanStatistics.empty() : planStatistics;
        this.inputTableStatistics = Collections.unmodifiableList(inputTableStatistics == null ? Collections.emptyList() : inputTableStatistics);
    }

    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PlanStatistics getPlanStatistics() {
        return this.planStatistics;
    }

    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public List<PlanStatistics> getInputTableStatistics() {
        return this.inputTableStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalPlanStatisticsEntry that = (HistoricalPlanStatisticsEntry)o;
        return Objects.equals(this.planStatistics, that.planStatistics) && Objects.equals(this.inputTableStatistics, that.inputTableStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.planStatistics, this.inputTableStatistics);
    }

    public String toString() {
        return String.format("HistoricalPlanStatisticsEntry{planStatistics=%s, inputTableStatistics=%s}", this.planStatistics, this.inputTableStatistics);
    }
}

