/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.analyzer;

import com.facebook.presto.jdbc.internal.common.CatalogSchemaName;
import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.predicate.TupleDomain;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ColumnMetadata;
import com.facebook.presto.jdbc.internal.spi.MaterializedViewDefinition;
import com.facebook.presto.jdbc.internal.spi.MaterializedViewStatus;
import com.facebook.presto.jdbc.internal.spi.TableHandle;
import com.facebook.presto.jdbc.internal.spi.analyzer.ViewDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface MetadataResolver {
    public boolean catalogExists(String var1);

    public boolean schemaExists(CatalogSchemaName var1);

    default public boolean tableExists(QualifiedObjectName tableName) {
        return this.getTableHandle(tableName).isPresent();
    }

    public Optional<TableHandle> getTableHandle(QualifiedObjectName var1);

    public List<ColumnMetadata> getColumns(TableHandle var1);

    public Map<String, ColumnHandle> getColumnHandles(TableHandle var1);

    public Optional<ViewDefinition> getView(QualifiedObjectName var1);

    default public boolean isView(QualifiedObjectName viewName) {
        return this.getView(viewName).isPresent();
    }

    public Optional<MaterializedViewDefinition> getMaterializedView(QualifiedObjectName var1);

    default public boolean isMaterializedView(QualifiedObjectName viewName) {
        return this.getMaterializedView(viewName).isPresent();
    }

    default public MaterializedViewStatus getMaterializedViewStatus(QualifiedObjectName materializedViewName, TupleDomain<String> baseQueryDomain) {
        throw new UnsupportedOperationException("getMaterializedViewStatus is not supported");
    }
}

