/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.common.block.AbstractRowBlock;
import com.facebook.presto.jdbc.internal.common.block.ArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.common.block.MapBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.RowBlockBuilder;

public class BlockBuilderUtils {
    private BlockBuilderUtils() {
    }

    public static void writePositionToBlockBuilder(Block block, int position, BlockBuilder blockBuilder) {
        if (block instanceof DictionaryBlock) {
            position = ((DictionaryBlock)block).getId(position);
            block = ((DictionaryBlock)block).getDictionary();
        }
        if (blockBuilder instanceof MapBlockBuilder) {
            BlockBuilderUtils.writePositionToMapBuilder(block, position, (MapBlockBuilder)blockBuilder);
        } else if (blockBuilder instanceof ArrayBlockBuilder) {
            BlockBuilderUtils.writePositionToArrayBuilder(block, position, (ArrayBlockBuilder)blockBuilder);
        } else if (blockBuilder instanceof RowBlockBuilder) {
            BlockBuilderUtils.writePositionToRowBuilder(block, position, (RowBlockBuilder)blockBuilder);
        } else {
            block.writePositionTo(position, blockBuilder);
        }
    }

    public static void writePositionToMapBuilder(Block block, int position, MapBlockBuilder mapBlockBuilder) {
        int i;
        if (!(block instanceof AbstractMapBlock)) {
            throw new IllegalArgumentException("Expected AbstractMapBlock");
        }
        mapBlockBuilder.beginBlockEntry();
        BlockBuilder keyBlockBuilder = mapBlockBuilder.getKeyBlockBuilder();
        BlockBuilder valueBlockBuilder = mapBlockBuilder.getValueBlockBuilder();
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int startOffset = mapBlock.getOffset(position);
        int endOffset = mapBlock.getOffset(position + 1);
        Block keyBlock = mapBlock.getRawKeyBlock();
        Block valueBlock = mapBlock.getRawValueBlock();
        for (i = startOffset; i < endOffset; ++i) {
            if (keyBlock.isNull(i)) {
                keyBlockBuilder.appendNull();
                continue;
            }
            BlockBuilderUtils.writePositionToBlockBuilder(keyBlock, i, keyBlockBuilder);
        }
        for (i = startOffset; i < endOffset; ++i) {
            if (valueBlock.isNull(i)) {
                valueBlockBuilder.appendNull();
                continue;
            }
            BlockBuilderUtils.writePositionToBlockBuilder(valueBlock, i, valueBlockBuilder);
        }
        mapBlockBuilder.closeEntry();
    }

    private static void writePositionToArrayBuilder(Block block, int position, ArrayBlockBuilder arrayBlockBuilder) {
        if (!(block instanceof AbstractArrayBlock)) {
            throw new IllegalArgumentException("Expected AbstractArrayBlock");
        }
        arrayBlockBuilder.beginBlockEntry();
        BlockBuilder elementBlockBuilder = arrayBlockBuilder.getElementBlockBuilder();
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        int startOffset = arrayBlock.getOffset(position);
        int endOffset = arrayBlock.getOffset(position + 1);
        Block elementBlock = arrayBlock.getRawElementBlock();
        for (int i = startOffset; i < endOffset; ++i) {
            if (elementBlock.isNull(i)) {
                elementBlockBuilder.appendNull();
                continue;
            }
            BlockBuilderUtils.writePositionToBlockBuilder(elementBlock, i, elementBlockBuilder);
        }
        arrayBlockBuilder.closeEntry();
    }

    private static void writePositionToRowBuilder(Block block, int position, RowBlockBuilder rowBlockBuilder) {
        if (!(block instanceof AbstractRowBlock)) {
            throw new IllegalArgumentException("Expected AbstractRowBlock");
        }
        rowBlockBuilder.beginBlockEntry();
        AbstractRowBlock rowBlock = (AbstractRowBlock)block;
        int offset = rowBlock.getFieldBlockOffset(position);
        for (int fieldIndex = 0; fieldIndex < rowBlock.numFields; ++fieldIndex) {
            BlockBuilder fieldBlockBuilder = rowBlockBuilder.getBlockBuilder(fieldIndex);
            Block fieldBlock = rowBlock.getRawFieldBlocks()[fieldIndex];
            if (fieldBlock.isNull(offset)) {
                fieldBlockBuilder.appendNull();
                continue;
            }
            BlockBuilderUtils.writePositionToBlockBuilder(fieldBlock, offset, fieldBlockBuilder);
        }
        rowBlockBuilder.closeEntry();
    }
}

