/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.analyzer;

import com.facebook.presto.jdbc.internal.common.transaction.TransactionId;
import com.facebook.presto.jdbc.internal.spi.security.AccessControl;
import com.facebook.presto.jdbc.internal.spi.security.AccessControlContext;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import java.util.Objects;
import java.util.Optional;

public final class AccessControlInfo {
    private final AccessControl accessControl;
    private final Identity identity;
    private final Optional<TransactionId> transactionId;
    private final AccessControlContext accessControlContext;

    public AccessControlInfo(AccessControl accessControl, Identity identity, Optional<TransactionId> transactionId, AccessControlContext accessControlContext) {
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.accessControlContext = Objects.requireNonNull(accessControlContext, "accessControlContext is null");
    }

    public AccessControl getAccessControl() {
        return this.accessControl;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlInfo that = (AccessControlInfo)o;
        return Objects.equals(this.accessControl, that.accessControl) && Objects.equals(this.identity, that.identity) && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.accessControlContext, that.accessControlContext);
    }

    public int hashCode() {
        return Objects.hash(this.accessControl, this.identity, this.transactionId, this.accessControlContext);
    }

    public String toString() {
        return "AccessControlInfo{accessControl=" + this.accessControl + ", identity=" + this.identity + ", transactionId=" + this.transactionId + ", accessControlContext=" + this.accessControlContext + '}';
    }
}

