/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.common.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.common.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.common.block.IntArrayBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;

public class IntArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        boolean mayHaveNull = block.mayHaveNull();
        for (int position = 0; position < positionCount; ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            sliceOutput.writeInt(block.getInt(position));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int[] values = new int[positionCount];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedIntArray(values));
        } else {
            for (int position = 0; position < values.length; ++position) {
                if (valueIsNull[position]) continue;
                values[position] = sliceInput.readInt();
            }
        }
        return new IntArrayBlock(0, positionCount, valueIsNull, values);
    }
}

