/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.BigintEnumType;
import com.facebook.presto.jdbc.internal.common.type.DistinctTypeInfo;
import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.ParameterKind;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameterUnion;
import com.facebook.presto.jdbc.internal.common.type.VarcharEnumType;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public class TypeSignatureParameter {
    private final ParameterKind kind;
    private final TypeSignatureParameterUnion value;

    public static TypeSignatureParameter of(TypeSignature typeSignature) {
        return new TypeSignatureParameter(ParameterKind.TYPE, typeSignature);
    }

    public static TypeSignatureParameter of(long longLiteral) {
        return new TypeSignatureParameter(ParameterKind.LONG, longLiteral);
    }

    public static TypeSignatureParameter of(NamedTypeSignature namedTypeSignature) {
        return new TypeSignatureParameter(ParameterKind.NAMED_TYPE, namedTypeSignature);
    }

    public static TypeSignatureParameter of(String variable) {
        return new TypeSignatureParameter(ParameterKind.VARIABLE, variable);
    }

    public static TypeSignatureParameter of(BigintEnumType.LongEnumMap enumMap) {
        return new TypeSignatureParameter(ParameterKind.LONG_ENUM, enumMap);
    }

    public static TypeSignatureParameter of(VarcharEnumType.VarcharEnumMap enumMap) {
        return new TypeSignatureParameter(ParameterKind.VARCHAR_ENUM, enumMap);
    }

    public static TypeSignatureParameter of(DistinctTypeInfo distinctTypeInfo) {
        return new TypeSignatureParameter(ParameterKind.DISTINCT_TYPE, distinctTypeInfo);
    }

    private TypeSignatureParameter(ParameterKind kind, Object value) {
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.value = TypeSignatureParameterUnion.convertToTypeSignatureParameterUnion(Objects.requireNonNull(value, "value is null"));
    }

    @ThriftConstructor
    public TypeSignatureParameter(ParameterKind kind, TypeSignatureParameterUnion value) {
        this.kind = kind;
        this.value = value;
    }

    public String toString() {
        return TypeSignatureParameterUnion.convertToValue(this.value).toString();
    }

    @ThriftField(value=1)
    public ParameterKind getKind() {
        return this.kind;
    }

    @ThriftField(value=2)
    public TypeSignatureParameterUnion getValue() {
        return this.value;
    }

    public boolean isTypeSignature() {
        return this.kind == ParameterKind.TYPE;
    }

    public boolean isLongLiteral() {
        return this.kind == ParameterKind.LONG;
    }

    public boolean isNamedTypeSignature() {
        return this.kind == ParameterKind.NAMED_TYPE;
    }

    public boolean isVariable() {
        return this.kind == ParameterKind.VARIABLE;
    }

    public boolean isLongEnum() {
        return this.kind == ParameterKind.LONG_ENUM;
    }

    public boolean isVarcharEnum() {
        return this.kind == ParameterKind.VARCHAR_ENUM;
    }

    public boolean isDistinctType() {
        return this.kind == ParameterKind.DISTINCT_TYPE;
    }

    private <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new IllegalArgumentException(String.format("ParameterKind is [%s] but expected [%s]", new Object[]{this.kind, expectedParameterKind}));
        }
        return target.cast(TypeSignatureParameterUnion.convertToValue(this.value));
    }

    public TypeSignature getTypeSignature() {
        return this.getValue(ParameterKind.TYPE, TypeSignature.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedTypeSignature getNamedTypeSignature() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedTypeSignature.class);
    }

    public String getVariable() {
        return this.getValue(ParameterKind.VARIABLE, String.class);
    }

    public BigintEnumType.LongEnumMap getLongEnumMap() {
        return this.getValue(ParameterKind.LONG_ENUM, BigintEnumType.LongEnumMap.class);
    }

    public VarcharEnumType.VarcharEnumMap getVarcharEnumMap() {
        return this.getValue(ParameterKind.VARCHAR_ENUM, VarcharEnumType.VarcharEnumMap.class);
    }

    public DistinctTypeInfo getDistinctTypeInfo() {
        return this.getValue(ParameterKind.DISTINCT_TYPE, DistinctTypeInfo.class);
    }

    public Optional<TypeSignature> getTypeSignatureOrNamedTypeSignature() {
        switch (this.kind) {
            case TYPE: {
                return Optional.of(this.getTypeSignature());
            }
            case NAMED_TYPE: {
                return Optional.of(this.getNamedTypeSignature().getTypeSignature());
            }
        }
        return Optional.empty();
    }

    public boolean isCalculated() {
        switch (this.kind) {
            case TYPE: {
                return this.getTypeSignature().isCalculated();
            }
            case NAMED_TYPE: {
                return this.getNamedTypeSignature().getTypeSignature().isCalculated();
            }
            case LONG: 
            case LONG_ENUM: 
            case VARCHAR_ENUM: 
            case DISTINCT_TYPE: {
                return false;
            }
            case VARIABLE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected parameter kind: " + (Object)((Object)this.kind));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignatureParameter other = (TypeSignatureParameter)o;
        return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value});
    }
}

