/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.security.ConnectorIdentity;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import com.facebook.presto.jdbc.internal.spi.security.PrestoPrincipal;
import java.security.Principal;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public class AccessDeniedException
extends PrestoException {
    public AccessDeniedException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Access Denied: " + message);
    }

    public static void denySetUser(Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, userName, null);
    }

    public static void denyQueryIntegrityCheck() {
        throw new AccessDeniedException("Query integrity check failed.");
    }

    public static void denySetUser(Optional<Principal> principal, String userName, String extraInfo) {
        throw new AccessDeniedException(String.format("Principal %s cannot become user %s%s", principal.orElse(null), userName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCatalogAccess(String catalogName) {
        AccessDeniedException.denyCatalogAccess(catalogName, null);
    }

    public static void denyCatalogAccess(String catalogName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot access catalog %s%s", catalogName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateSchema(String schemaName) {
        AccessDeniedException.denyCreateSchema(schemaName, null);
    }

    public static void denyCreateSchema(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create schema %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropSchema(String schemaName) {
        AccessDeniedException.denyDropSchema(schemaName, null);
    }

    public static void denyDropSchema(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop schema %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameSchema(String schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schemaName, newSchemaName, null);
    }

    public static void denyRenameSchema(String schemaName, String newSchemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename schema from %s to %s%s", schemaName, newSchemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowSchemas() {
        AccessDeniedException.denyShowSchemas(null);
    }

    public static void denyShowSchemas(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show schemas%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateTable(String tableName) {
        AccessDeniedException.denyCreateTable(tableName, null);
    }

    public static void denyCreateTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropTable(String tableName) {
        AccessDeniedException.denyDropTable(tableName, null);
    }

    public static void denyDropTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameTable(String tableName, String newTableName) {
        AccessDeniedException.denyRenameTable(tableName, newTableName, null);
    }

    public static void denyRenameTable(String tableName, String newTableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename table from %s to %s%s", tableName, newTableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowTablesMetadata(String schemaName) {
        AccessDeniedException.denyShowTablesMetadata(schemaName, null);
    }

    public static void denyShowTablesMetadata(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show metadata of tables in %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyAddColumn(String tableName) {
        AccessDeniedException.denyAddColumn(tableName, null);
    }

    public static void denyAddColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot add a column to table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropColumn(String tableName) {
        AccessDeniedException.denyDropColumn(tableName, null);
    }

    public static void denyDropColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop a column from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameColumn(String tableName) {
        AccessDeniedException.denyRenameColumn(tableName, null);
    }

    public static void denyRenameColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename a column in table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySelectTable(String tableName) {
        AccessDeniedException.denySelectTable(tableName, null);
    }

    public static void denySelectTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyInsertTable(String tableName) {
        AccessDeniedException.denyInsertTable(tableName, null);
    }

    public static void denyInsertTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot insert into table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDeleteTable(String tableName) {
        AccessDeniedException.denyDeleteTable(tableName, null);
    }

    public static void denyDeleteTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot delete from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyTruncateTable(String tableName) {
        AccessDeniedException.denyTruncateTable(tableName, null);
    }

    public static void denyTruncateTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot truncate table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyUpdateTableColumns(String tableName, Set<String> updatedColumnNames) {
        AccessDeniedException.denyUpdateTableColumns(tableName, updatedColumnNames, null);
    }

    public static void denyUpdateTableColumns(String tableName, Set<String> updatedColumnNames, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot update columns [%s] in table %s%s", updatedColumnNames, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateView(String viewName) {
        AccessDeniedException.denyCreateView(viewName, null);
    }

    public static void denyCreateView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateViewWithSelect(String sourceName, Identity identity) {
        AccessDeniedException.denyCreateViewWithSelect(sourceName, identity.toConnectorIdentity());
    }

    public static void denyCreateViewWithSelect(String sourceName, ConnectorIdentity identity) {
        AccessDeniedException.denyCreateViewWithSelect(sourceName, identity, null);
    }

    public static void denyCreateViewWithSelect(String sourceName, ConnectorIdentity identity, String extraInfo) {
        throw new AccessDeniedException(String.format("View owner '%s' cannot create view that selects from %s%s", identity.getUser(), sourceName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropView(String viewName) {
        AccessDeniedException.denyDropView(viewName, null);
    }

    public static void denyDropView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySelectView(String viewName) {
        AccessDeniedException.denySelectView(viewName, null);
    }

    public static void denySelectView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyGrantTablePrivilege(String privilege, String tableName) {
        AccessDeniedException.denyGrantTablePrivilege(privilege, tableName, null);
    }

    public static void denyGrantTablePrivilege(String privilege, String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot grant privilege %s on table %s%s", privilege, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRevokeTablePrivilege(String privilege, String tableName) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege, tableName, null);
    }

    public static void denyRevokeTablePrivilege(String privilege, String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot revoke privilege %s on table %s%s", privilege, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowRoles(String catalogName) {
        throw new AccessDeniedException(String.format("Cannot show roles from catalog %s", catalogName));
    }

    public static void denyShowCurrentRoles(String catalogName) {
        throw new AccessDeniedException(String.format("Cannot show current roles from catalog %s", catalogName));
    }

    public static void denyShowRoleGrants(String catalogName) {
        throw new AccessDeniedException(String.format("Cannot show role grants from catalog %s", catalogName));
    }

    public static void denySetSystemSessionProperty(String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty(propertyName, null);
    }

    public static void denySetSystemSessionProperty(String propertyName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set system session property %s%s", propertyName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetCatalogSessionProperty(String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(catalogName, propertyName, null);
    }

    public static void denySetCatalogSessionProperty(String catalogName, String propertyName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set catalog session property %s.%s%s", catalogName, propertyName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetCatalogSessionProperty(String propertyName) {
        throw new AccessDeniedException(String.format("Cannot set catalog session property %s", propertyName));
    }

    public static void denySelectColumns(String tableName, Collection<String> columnNames) {
        AccessDeniedException.denySelectColumns(tableName, columnNames, null);
    }

    public static void denySelectColumns(String tableName, Collection<String> columnNames, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from columns %s in table or view %s%s", columnNames, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateRole(String roleName) {
        throw new AccessDeniedException(String.format("Cannot create role %s", roleName));
    }

    public static void denyDropRole(String roleName) {
        throw new AccessDeniedException(String.format("Cannot drop role %s", roleName));
    }

    public static void denyGrantRoles(Set<String> roles, Set<PrestoPrincipal> grantees) {
        throw new AccessDeniedException(String.format("Cannot grant roles %s to %s ", roles, grantees));
    }

    public static void denyRevokeRoles(Set<String> roles, Set<PrestoPrincipal> grantees) {
        throw new AccessDeniedException(String.format("Cannot revoke roles %s from %s ", roles, grantees));
    }

    public static void denySetRole(String role) {
        throw new AccessDeniedException(String.format("Cannot set role %s", role));
    }

    public static void denyDropConstraint(String tableName) {
        AccessDeniedException.denyDropConstraint(tableName, null);
    }

    public static void denyDropConstraint(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop a constraint from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyAddConstraint(String tableName) {
        AccessDeniedException.denyAddConstraint(tableName, null);
    }

    public static void denyAddConstraint(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot add a constraint to table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    private static Object formatExtraInfo(String extraInfo) {
        if (extraInfo == null || extraInfo.isEmpty()) {
            return "";
        }
        return ": " + extraInfo;
    }
}

