/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import com.facebook.presto.jdbc.internal.joda.time.DateTimeZone;
import com.facebook.presto.jdbc.internal.joda.time.Interval;
import java.io.IOException;

public class IntervalDeserializer
extends JodaDateDeserializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public IntervalDeserializer(JacksonJodaDateFormat format) {
        super(Interval.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new IntervalDeserializer(format);
    }

    @Override
    public Interval deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        DateTimeZone tz;
        Interval result;
        boolean hasSlash;
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            return (Interval)ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "expected JSON String", new Object[0]);
        }
        String v = p.getText().trim();
        int index = v.indexOf(47, 1);
        boolean bl = hasSlash = index > 0;
        if (!hasSlash) {
            index = v.indexOf(45, 1);
        }
        if (index < 0) {
            throw ctxt.weirdStringException(v, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = v.substring(0, index);
        try {
            if (hasSlash) {
                result = Interval.parseWithOffset(v);
            } else {
                long start = Long.valueOf(str);
                str = v.substring(index + 1);
                long end = Long.valueOf(str);
                result = new Interval(start, end);
            }
        }
        catch (NumberFormatException e) {
            return (Interval)ctxt.handleWeirdStringValue(this.handledType(), str, "Failed to parse number from '%s' (full source String '%s')", str, v);
        }
        DateTimeZone contextTimezone = this._format.shouldAdjustToContextTimeZone(ctxt) ? DateTimeZone.forTimeZone(ctxt.getTimeZone()) : null;
        DateTimeZone dateTimeZone = tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : contextTimezone;
        if (tz != null && !tz.equals(result.getStart().getZone())) {
            result = new Interval(result.getStartMillis(), result.getEndMillis(), tz);
        }
        return result;
    }
}

