/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector;

import com.facebook.presto.jdbc.internal.common.type.Type;
import java.util.Objects;

public class ConnectorTableVersion {
    private final VersionType versionType;
    private final VersionOperator versionOperator;
    private final Type versionExpressionType;
    private final Object tableVersion;

    public ConnectorTableVersion(VersionType versionType, VersionOperator versionOperator, Type versionExpressionType, Object tableVersion) {
        Objects.requireNonNull(versionType, "versionType is null");
        Objects.requireNonNull(versionOperator, "versionOperator is null");
        Objects.requireNonNull(versionExpressionType, "versionExpressionType is null");
        Objects.requireNonNull(tableVersion, "tableVersion is null");
        this.versionType = versionType;
        this.versionOperator = versionOperator;
        this.versionExpressionType = versionExpressionType;
        this.tableVersion = tableVersion;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public VersionOperator getVersionOperator() {
        return this.versionOperator;
    }

    public Type getVersionExpressionType() {
        return this.versionExpressionType;
    }

    public Object getTableVersion() {
        return this.tableVersion;
    }

    public String toString() {
        return "ConnectorTableVersion{" + "tableVersionType=" + (Object)((Object)this.versionType) + ", versionExpressionType=" + this.versionExpressionType + ", tableVersion=" + this.tableVersion + '}';
    }

    public static enum VersionOperator {
        EQUAL,
        LESS_THAN;

    }

    public static enum VersionType {
        TIMESTAMP,
        VERSION;

    }
}

