/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.eventlistener;

import com.facebook.presto.jdbc.internal.common.RuntimeStats;
import com.facebook.presto.jdbc.internal.io.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.io.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class OperatorStatistics {
    private final int stageId;
    private final int stageExecutionId;
    private final int pipelineId;
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final long totalDrivers;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final DataSize addInputAllocation;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize inputDataSize;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final DataSize getOutputAllocation;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final DataSize finishAllocation;
    private final DataSize userMemoryReservation;
    private final DataSize revocableMemoryReservation;
    private final DataSize systemMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakSystemMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize spilledDataSize;
    private final Optional<String> info;
    private final RuntimeStats runtimeStats;
    private final double estimateOutputDataSize;
    private final double estimateOutputPositions;

    public OperatorStatistics(int stageId, int stageExecutionId, int pipelineId, int operatorId, PlanNodeId planNodeId, String operatorType, long totalDrivers, long addInputCalls, Duration addInputWall, Duration addInputCpu, DataSize addInputAllocation, DataSize rawInputDataSize, long rawInputPositions, DataSize inputDataSize, long inputPositions, double sumSquaredInputPositions, long getOutputCalls, Duration getOutputWall, Duration getOutputCpu, DataSize getOutputAllocation, DataSize outputDataSize, long outputPositions, DataSize physicalWrittenDataSize, Duration blockedWall, long finishCalls, Duration finishWall, Duration finishCpu, DataSize finishAllocation, DataSize userMemoryReservation, DataSize revocableMemoryReservation, DataSize systemMemoryReservation, DataSize peakUserMemoryReservation, DataSize peakSystemMemoryReservation, DataSize peakTotalMemoryReservation, DataSize spilledDataSize, Optional<String> info, RuntimeStats runtimeStats, double estimateOutputDataSize, double estimateOutputPositions) {
        this.stageId = stageId;
        this.stageExecutionId = stageExecutionId;
        this.pipelineId = pipelineId;
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        this.addInputAllocation = Objects.requireNonNull(addInputAllocation, "addInputAllocation is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = rawInputPositions;
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        this.getOutputAllocation = Objects.requireNonNull(getOutputAllocation, "getOutputAllocation is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "writtenDataSize is null");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        this.finishAllocation = Objects.requireNonNull(finishAllocation, "finishAllocation is null");
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.revocableMemoryReservation = Objects.requireNonNull(revocableMemoryReservation, "revocableMemoryReservation is null");
        this.systemMemoryReservation = Objects.requireNonNull(systemMemoryReservation, "systemMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakSystemMemoryReservation = Objects.requireNonNull(peakSystemMemoryReservation, "peakSystemMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.spilledDataSize = Objects.requireNonNull(spilledDataSize, "spilledDataSize is null");
        this.info = Objects.requireNonNull(info, "info is null");
        this.runtimeStats = runtimeStats;
        this.estimateOutputDataSize = estimateOutputDataSize;
        this.estimateOutputPositions = estimateOutputPositions;
    }

    public int getStageId() {
        return this.stageId;
    }

    public int getStageExecutionId() {
        return this.stageExecutionId;
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    public DataSize getAddInputAllocation() {
        return this.addInputAllocation;
    }

    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    public DataSize getInputDataSize() {
        return this.inputDataSize;
    }

    public long getInputPositions() {
        return this.inputPositions;
    }

    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    public DataSize getGetOutputAllocation() {
        return this.getOutputAllocation;
    }

    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    public long getOutputPositions() {
        return this.outputPositions;
    }

    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    public long getFinishCalls() {
        return this.finishCalls;
    }

    public Duration getFinishWall() {
        return this.finishWall;
    }

    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    public DataSize getFinishAllocation() {
        return this.finishAllocation;
    }

    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    public DataSize getRevocableMemoryReservation() {
        return this.revocableMemoryReservation;
    }

    public DataSize getSystemMemoryReservation() {
        return this.systemMemoryReservation;
    }

    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    public DataSize getPeakSystemMemoryReservation() {
        return this.peakSystemMemoryReservation;
    }

    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    public DataSize getSpilledDataSize() {
        return this.spilledDataSize;
    }

    public Optional<String> getInfo() {
        return this.info;
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public double getEstimateOutputDataSize() {
        return this.estimateOutputDataSize;
    }

    public double getEstimateOutputPositions() {
        return this.estimateOutputPositions;
    }
}

