/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.session;

import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;

public class SessionPropertyMetadata {
    private final String name;
    private final String description;
    private final TypeSignature typeSignature;
    private final String defaultValue;
    private final boolean hidden;

    @JsonCreator
    public SessionPropertyMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="defaultValue") String defaultValue, @JsonProperty(value="hidden") boolean hidden) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.description = Objects.requireNonNull(description, "description is null");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature is null");
        this.defaultValue = defaultValue;
        this.hidden = hidden;
        if (name.isEmpty() || !name.trim().toLowerCase(Locale.ENGLISH).equals(name)) {
            throw new IllegalArgumentException(String.format("Invalid property name '%s'", name));
        }
        if (description.isEmpty() || !description.trim().equals(description)) {
            throw new IllegalArgumentException(String.format("Invalid property description '%s'", description));
        }
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    @JsonProperty
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionPropertyMetadata)) {
            return false;
        }
        SessionPropertyMetadata that = (SessionPropertyMetadata)o;
        return this.hidden == that.hidden && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.typeSignature, that.typeSignature) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.typeSignature, this.defaultValue, this.hidden);
    }
}

