/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.statistics.ColumnStatisticType;
import java.util.List;
import java.util.Objects;

public class ColumnStatisticMetadata {
    private final String columnName;
    private final ColumnStatisticType statisticType;
    private final String function;
    private final List<String> columnArguments;
    private final boolean sqlExpression;

    @JsonCreator
    public ColumnStatisticMetadata(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="statisticType") ColumnStatisticType statisticType, @JsonProperty(value="function") String function, @JsonProperty(value="columnArguments") List<String> columnArguments, @JsonProperty(value="sqlExpression") boolean sqlExpression) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.statisticType = Objects.requireNonNull(statisticType, "statisticType is null");
        this.function = Objects.requireNonNull(function, "functionName is null");
        this.columnArguments = Objects.requireNonNull(columnArguments, "additionalArguments is null");
        this.sqlExpression = sqlExpression;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public ColumnStatisticType getStatisticType() {
        return this.statisticType;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public List<String> getColumnArguments() {
        return this.columnArguments;
    }

    @JsonProperty
    public boolean isSqlExpression() {
        return this.sqlExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatisticMetadata that = (ColumnStatisticMetadata)o;
        return Objects.equals(this.columnName, that.columnName) && this.statisticType == that.statisticType && Objects.equals(this.function, that.function) && Objects.equals(this.columnArguments, that.columnArguments) && Objects.equals(this.sqlExpression, that.sqlExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.statisticType, this.function, this.columnArguments, this.sqlExpression});
    }

    public String toString() {
        return "ColumnStatisticMetadata{columnName='" + this.columnName + '\'' + ", statisticType=" + (Object)((Object)this.statisticType) + ", function=" + this.function + ", columnArguments=" + this.columnArguments + ", sqlExpression=" + this.sqlExpression + '}';
    }
}

