/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class OutputNode
extends PlanNode {
    private final PlanNode source;
    private final List<String> columnNames;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public OutputNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables) {
        this(sourceLocation, id, Optional.empty(), source, columnNames, outputVariables);
    }

    public OutputNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, List<String> columnNames, List<VariableReferenceExpression> outputVariables) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        if (columnNames.size() != outputVariables.size()) {
            throw new IllegalArgumentException("columnNames and assignments sizes don't match");
        }
        this.source = source;
        this.columnNames = columnNames;
        this.outputVariables = Collections.unmodifiableList(outputVariables);
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitOutput(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("new children size must be one.");
        }
        return new OutputNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.columnNames, this.outputVariables);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new OutputNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.columnNames, this.outputVariables);
    }
}

