/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonIgnore;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorId;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableMetadata;
import com.facebook.presto.jdbc.internal.spi.NewTableLayout;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.TableHandle;
import com.facebook.presto.jdbc.internal.spi.plan.PartitioningScheme;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.plan.StatisticAggregations;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public final class TableWriterNode
extends PlanNode {
    private final PlanNode source;
    private final Optional<WriterTarget> target;
    private final VariableReferenceExpression rowCountVariable;
    private final VariableReferenceExpression fragmentVariable;
    private final VariableReferenceExpression tableCommitContextVariable;
    private final List<VariableReferenceExpression> columns;
    private final List<String> columnNames;
    private final Set<VariableReferenceExpression> notNullColumnVariables;
    private final Optional<PartitioningScheme> tablePartitioningScheme;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final List<VariableReferenceExpression> outputs;
    private final Optional<Integer> taskCountIfScaledWriter;
    private final Optional<Boolean> isTemporaryTableWriter;

    @JsonCreator
    public TableWriterNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") Optional<WriterTarget> target, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="fragmentVariable") VariableReferenceExpression fragmentVariable, @JsonProperty(value="tableCommitContextVariable") VariableReferenceExpression tableCommitContextVariable, @JsonProperty(value="columns") List<VariableReferenceExpression> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="notNullColumnVariables") Set<VariableReferenceExpression> notNullColumnVariables, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> tablePartitioningScheme, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="taskCountIfScaledWriter") Optional<Integer> taskCountIfScaledWriter, @JsonProperty(value="isTemporaryTableWriter") Optional<Boolean> isTemporaryTableWriter) {
        this(sourceLocation, id, Optional.empty(), source, target, rowCountVariable, fragmentVariable, tableCommitContextVariable, columns, columnNames, notNullColumnVariables, tablePartitioningScheme, statisticsAggregation, taskCountIfScaledWriter, isTemporaryTableWriter);
    }

    public TableWriterNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, Optional<WriterTarget> target, VariableReferenceExpression rowCountVariable, VariableReferenceExpression fragmentVariable, VariableReferenceExpression tableCommitContextVariable, List<VariableReferenceExpression> columns, List<String> columnNames, Set<VariableReferenceExpression> notNullColumnVariables, Optional<PartitioningScheme> tablePartitioningScheme, Optional<StatisticAggregations> statisticsAggregation, Optional<Integer> taskCountIfScaledWriter, Optional<Boolean> isTemporaryTableWriter) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Utils.checkArgument(columns.size() == columnNames.size(), "columns and columnNames sizes don't match", new Object[0]);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.fragmentVariable = Objects.requireNonNull(fragmentVariable, "fragmentVariable is null");
        this.tableCommitContextVariable = Objects.requireNonNull(tableCommitContextVariable, "tableCommitContextVariable is null");
        this.columns = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(columns));
        this.columnNames = Collections.unmodifiableList(new ArrayList<String>(columnNames));
        this.notNullColumnVariables = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(notNullColumnVariables, "notNullColumns is null")));
        this.tablePartitioningScheme = Objects.requireNonNull(tablePartitioningScheme, "partitioningScheme is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        ArrayList<VariableReferenceExpression> outputsList = new ArrayList<VariableReferenceExpression>();
        outputsList.add(rowCountVariable);
        outputsList.add(fragmentVariable);
        outputsList.add(tableCommitContextVariable);
        statisticsAggregation.ifPresent(aggregation -> {
            outputsList.addAll(aggregation.getGroupingVariables());
            outputsList.addAll(aggregation.getAggregations().keySet());
        });
        this.outputs = Collections.unmodifiableList(outputsList);
        this.taskCountIfScaledWriter = Objects.requireNonNull(taskCountIfScaledWriter, "taskCountIfScaledWriter is null");
        this.isTemporaryTableWriter = Objects.requireNonNull(isTemporaryTableWriter, "isTemporaryTableWriter is null");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<WriterTarget> getTarget() {
        return this.target;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getFragmentVariable() {
        return this.fragmentVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getTableCommitContextVariable() {
        return this.tableCommitContextVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getNotNullColumnVariables() {
        return this.notNullColumnVariables;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getTablePartitioningScheme() {
        return this.tablePartitioningScheme;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputs;
    }

    @JsonProperty
    public Optional<Integer> getTaskCountIfScaledWriter() {
        return this.taskCountIfScaledWriter;
    }

    @JsonProperty
    public Optional<Boolean> getIsTemporaryTableWriter() {
        return this.isTemporaryTableWriter;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 1);
        return new TableWriterNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.target, this.rowCountVariable, this.fragmentVariable, this.tableCommitContextVariable, this.columns, this.columnNames, this.notNullColumnVariables, this.tablePartitioningScheme, this.statisticsAggregation, this.taskCountIfScaledWriter, this.isTemporaryTableWriter);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new TableWriterNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.target, this.rowCountVariable, this.fragmentVariable, this.tableCommitContextVariable, this.columns, this.columnNames, this.notNullColumnVariables, this.tablePartitioningScheme, this.statisticsAggregation, this.taskCountIfScaledWriter, this.isTemporaryTableWriter);
    }

    public boolean isSingleWriterPerPartitionRequired() {
        return this.tablePartitioningScheme.isPresent() && !this.tablePartitioningScheme.get().isScaleWriters();
    }

    public static class UpdateTarget
    extends WriterTarget {
        private final TableHandle handle;
        private final SchemaTableName schemaTableName;
        private final List<String> updatedColumns;
        private final List<ColumnHandle> updatedColumnHandles;

        public UpdateTarget(TableHandle handle, SchemaTableName schemaTableName, List<String> updatedColumns, List<ColumnHandle> updatedColumnHandles) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            Utils.checkArgument(updatedColumns.size() == updatedColumnHandles.size(), String.format("updatedColumns size %s must equal updatedColumnHandles size %s", updatedColumns.size(), updatedColumnHandles.size()), new Object[0]);
            this.updatedColumns = Objects.requireNonNull(updatedColumns, "updatedColumns is null");
            this.updatedColumnHandles = Objects.requireNonNull(updatedColumnHandles, "updatedColumnHandles is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public ConnectorId getConnectorId() {
            return this.handle.getConnectorId();
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        public List<String> getUpdatedColumns() {
            return this.updatedColumns;
        }

        public List<ColumnHandle> getUpdatedColumnHandles() {
            return this.updatedColumnHandles;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class RefreshMaterializedViewReference
    extends WriterTarget {
        private final TableHandle handle;
        private final SchemaTableName schemaTableName;

        public RefreshMaterializedViewReference(TableHandle handle, SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public ConnectorId getConnectorId() {
            return this.handle.getConnectorId();
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class DeleteHandle
    extends WriterTarget {
        private final TableHandle handle;
        private final SchemaTableName schemaTableName;

        public DeleteHandle(TableHandle handle, SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public ConnectorId getConnectorId() {
            return this.handle.getConnectorId();
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertReference
    extends WriterTarget {
        private final TableHandle handle;
        private final SchemaTableName schemaTableName;

        public InsertReference(TableHandle handle, SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public ConnectorId getConnectorId() {
            return this.handle.getConnectorId();
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateName
    extends WriterTarget {
        private final ConnectorId connectorId;
        private final ConnectorTableMetadata tableMetadata;
        private final Optional<NewTableLayout> layout;

        public CreateName(ConnectorId connectorId, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
        }

        @Override
        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public ConnectorTableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        public Optional<NewTableLayout> getLayout() {
            return this.layout;
        }

        @Override
        public SchemaTableName getSchemaTableName() {
            return this.tableMetadata.getTable();
        }

        @Override
        public String toString() {
            return this.connectorId + "." + this.tableMetadata.getTable();
        }
    }

    public static abstract class WriterTarget {
        public abstract ConnectorId getConnectorId();

        public abstract SchemaTableName getSchemaTableName();

        public abstract String toString();
    }
}

