/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.function;

import com.facebook.presto.jdbc.internal.common.type.TimeZoneKey;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SqlFunctionProperties {
    private final boolean parseDecimalLiteralAsDouble;
    private final boolean legacyRowFieldOrdinalAccessEnabled;
    private final TimeZoneKey timeZoneKey;
    private final boolean legacyTimestamp;
    private final boolean legacyMapSubscript;
    private final long sessionStartTime;
    private final Locale sessionLocale;
    private final String sessionUser;
    private final boolean fieldNamesInJsonCastEnabled;
    private final boolean legacyJsonCast;
    private final Map<String, String> extraCredentials;
    private final boolean warnOnCommonNanPatterns;
    private final boolean canonicalizedJsonExtract;

    private SqlFunctionProperties(boolean parseDecimalLiteralAsDouble, boolean legacyRowFieldOrdinalAccessEnabled, TimeZoneKey timeZoneKey, boolean legacyTimestamp, boolean legacyMapSubscript, long sessionStartTime, Locale sessionLocale, String sessionUser, boolean fieldNamesInJsonCastEnabled, boolean legacyJsonCast, Map<String, String> extraCredentials, boolean warnOnCommonNanPatterns, boolean canonicalizedJsonExtract) {
        this.parseDecimalLiteralAsDouble = parseDecimalLiteralAsDouble;
        this.legacyRowFieldOrdinalAccessEnabled = legacyRowFieldOrdinalAccessEnabled;
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.legacyTimestamp = legacyTimestamp;
        this.legacyMapSubscript = legacyMapSubscript;
        this.sessionStartTime = sessionStartTime;
        this.sessionLocale = Objects.requireNonNull(sessionLocale, "sessionLocale is null");
        this.sessionUser = Objects.requireNonNull(sessionUser, "sessionUser is null");
        this.fieldNamesInJsonCastEnabled = fieldNamesInJsonCastEnabled;
        this.legacyJsonCast = legacyJsonCast;
        this.extraCredentials = Objects.requireNonNull(extraCredentials, "extraCredentials is null");
        this.warnOnCommonNanPatterns = warnOnCommonNanPatterns;
        this.canonicalizedJsonExtract = canonicalizedJsonExtract;
    }

    public boolean isParseDecimalLiteralAsDouble() {
        return this.parseDecimalLiteralAsDouble;
    }

    public boolean isLegacyRowFieldOrdinalAccessEnabled() {
        return this.legacyRowFieldOrdinalAccessEnabled;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @Deprecated
    public boolean isLegacyTimestamp() {
        return this.legacyTimestamp;
    }

    public boolean isLegacyMapSubscript() {
        return this.legacyMapSubscript;
    }

    public long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public Locale getSessionLocale() {
        return this.sessionLocale;
    }

    public String getSessionUser() {
        return this.sessionUser;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public boolean isFieldNamesInJsonCastEnabled() {
        return this.fieldNamesInJsonCastEnabled;
    }

    public boolean isLegacyJsonCast() {
        return this.legacyJsonCast;
    }

    public boolean shouldWarnOnCommonNanPatterns() {
        return this.warnOnCommonNanPatterns;
    }

    public boolean isCanonicalizedJsonExtract() {
        return this.canonicalizedJsonExtract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFunctionProperties)) {
            return false;
        }
        SqlFunctionProperties that = (SqlFunctionProperties)o;
        return Objects.equals(this.parseDecimalLiteralAsDouble, that.parseDecimalLiteralAsDouble) && Objects.equals(this.legacyRowFieldOrdinalAccessEnabled, that.legacyRowFieldOrdinalAccessEnabled) && Objects.equals(this.timeZoneKey, that.timeZoneKey) && Objects.equals(this.legacyTimestamp, that.legacyTimestamp) && Objects.equals(this.legacyMapSubscript, that.legacyMapSubscript) && Objects.equals(this.sessionStartTime, that.sessionStartTime) && Objects.equals(this.sessionLocale, that.sessionLocale) && Objects.equals(this.sessionUser, that.sessionUser) && Objects.equals(this.extraCredentials, that.extraCredentials) && Objects.equals(this.legacyJsonCast, that.legacyJsonCast) && Objects.equals(this.canonicalizedJsonExtract, that.legacyJsonCast);
    }

    public int hashCode() {
        return Objects.hash(this.parseDecimalLiteralAsDouble, this.legacyRowFieldOrdinalAccessEnabled, this.timeZoneKey, this.legacyTimestamp, this.legacyMapSubscript, this.sessionStartTime, this.sessionLocale, this.sessionUser, this.extraCredentials, this.legacyJsonCast, this.canonicalizedJsonExtract);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean parseDecimalLiteralAsDouble;
        private boolean legacyRowFieldOrdinalAccessEnabled;
        private TimeZoneKey timeZoneKey;
        private boolean legacyTimestamp;
        private boolean legacyMapSubscript;
        private long sessionStartTime;
        private Locale sessionLocale;
        private String sessionUser;
        private boolean fieldNamesInJsonCastEnabled;
        private boolean legacyJsonCast;
        private Map<String, String> extraCredentials = Collections.emptyMap();
        private boolean warnOnCommonNanPatterns;
        private boolean canonicalizedJsonExtract;

        private Builder() {
        }

        public Builder setParseDecimalLiteralAsDouble(boolean parseDecimalLiteralAsDouble) {
            this.parseDecimalLiteralAsDouble = parseDecimalLiteralAsDouble;
            return this;
        }

        public Builder setLegacyRowFieldOrdinalAccessEnabled(boolean legacyRowFieldOrdinalAccessEnabled) {
            this.legacyRowFieldOrdinalAccessEnabled = legacyRowFieldOrdinalAccessEnabled;
            return this;
        }

        public Builder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
            return this;
        }

        public Builder setLegacyTimestamp(boolean legacyTimestamp) {
            this.legacyTimestamp = legacyTimestamp;
            return this;
        }

        public Builder setLegacyMapSubscript(boolean legacyMapSubscript) {
            this.legacyMapSubscript = legacyMapSubscript;
            return this;
        }

        public Builder setSessionStartTime(long sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public Builder setSessionLocale(Locale sessionLocale) {
            this.sessionLocale = sessionLocale;
            return this;
        }

        public Builder setSessionUser(String sessionUser) {
            this.sessionUser = sessionUser;
            return this;
        }

        public Builder setExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials = Collections.unmodifiableMap(extraCredentials);
            return this;
        }

        public Builder setFieldNamesInJsonCastEnabled(boolean fieldNamesInJsonCastEnabled) {
            this.fieldNamesInJsonCastEnabled = fieldNamesInJsonCastEnabled;
            return this;
        }

        public Builder setLegacyJsonCast(boolean legacyJsonCast) {
            this.legacyJsonCast = legacyJsonCast;
            return this;
        }

        public Builder setWarnOnCommonNanPatterns(boolean warnOnCommonNanPatterns) {
            this.warnOnCommonNanPatterns = warnOnCommonNanPatterns;
            return this;
        }

        public Builder setCanonicalizedJsonExtract(boolean canonicalizedJsonExtract) {
            this.canonicalizedJsonExtract = canonicalizedJsonExtract;
            return this;
        }

        public SqlFunctionProperties build() {
            return new SqlFunctionProperties(this.parseDecimalLiteralAsDouble, this.legacyRowFieldOrdinalAccessEnabled, this.timeZoneKey, this.legacyTimestamp, this.legacyMapSubscript, this.sessionStartTime, this.sessionLocale, this.sessionUser, this.fieldNamesInJsonCastEnabled, this.legacyJsonCast, this.extraCredentials, this.warnOnCommonNanPatterns, this.canonicalizedJsonExtract);
        }
    }
}

