/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.RowFieldName;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public class NamedTypeSignature {
    private final Optional<RowFieldName> fieldName;
    private final TypeSignature typeSignature;

    @ThriftConstructor
    @JsonCreator
    public NamedTypeSignature(@JsonProperty(value="fieldName") Optional<RowFieldName> fieldName, @JsonProperty(value="typeSignature") TypeSignature typeSignature) {
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName is null");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature is null");
    }

    @ThriftField(value=1)
    @JsonProperty
    public Optional<RowFieldName> getFieldName() {
        return this.fieldName;
    }

    @ThriftField(value=2)
    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public Optional<String> getName() {
        return this.getFieldName().map(RowFieldName::getName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedTypeSignature other = (NamedTypeSignature)o;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.typeSignature, other.typeSignature);
    }

    public String toString() {
        if (this.fieldName.isPresent()) {
            return String.format("%s %s", this.fieldName.get(), this.typeSignature);
        }
        return this.typeSignature.toString();
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.typeSignature);
    }
}

