/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftEnum;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftEnumValue;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.Optional;

@ThriftEnum
public enum ParameterKind {
    TYPE(Optional.of("TYPE_SIGNATURE"), 1),
    NAMED_TYPE(Optional.of("NAMED_TYPE_SIGNATURE"), 2),
    LONG(Optional.of("LONG_LITERAL"), 3),
    VARIABLE(Optional.empty(), 4),
    LONG_ENUM(Optional.of("LONG_ENUM"), 5),
    VARCHAR_ENUM(Optional.of("VARCHAR_ENUM"), 6),
    DISTINCT_TYPE(Optional.of("DISTINCT_TYPE"), 7);

    private final Optional<String> oldName;
    private final int value;

    private ParameterKind(Optional<String> oldName, int value) {
        this.oldName = oldName;
        this.value = value;
    }

    @JsonValue
    public String jsonName() {
        return this.oldName.orElse(this.name());
    }

    @JsonCreator
    public static ParameterKind fromJsonValue(String value) {
        for (ParameterKind kind : ParameterKind.values()) {
            if (kind.oldName.isPresent() && kind.oldName.get().equals(value)) {
                return kind;
            }
            if (!kind.name().equals(value)) continue;
            return kind;
        }
        throw new IllegalArgumentException("Invalid serialized ParameterKind value: " + value);
    }

    @ThriftEnumValue
    public int getValue() {
        return this.value;
    }
}

