/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.SchemaTablePrefix;
import com.facebook.presto.jdbc.internal.spi.SchemaUtil;
import java.util.Locale;
import java.util.Objects;

@ThriftStruct
public class SchemaTableName {
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    @ThriftConstructor
    public SchemaTableName(@JsonProperty(value="schema") String schemaName, @JsonProperty(value="table") String tableName) {
        this.schemaName = SchemaUtil.checkNotEmpty(schemaName, "schemaName").toLowerCase(Locale.ENGLISH);
        this.tableName = SchemaUtil.checkNotEmpty(tableName, "tableName").toLowerCase(Locale.ENGLISH);
    }

    public static SchemaTableName valueOf(String schemaTableName) {
        SchemaUtil.checkNotEmpty(schemaTableName, "schemaTableName");
        String[] parts = schemaTableName.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException("SchemaTableName should have exactly 2 parts");
        }
        return new SchemaTableName(parts[0], parts[1]);
    }

    @JsonProperty(value="schema")
    @ThriftField(value=1)
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="table")
    @ThriftField(value=2)
    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTableName other = (SchemaTableName)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return this.schemaName + '.' + this.tableName;
    }

    public SchemaTablePrefix toSchemaTablePrefix() {
        return new SchemaTablePrefix(this.schemaName, this.tableName);
    }
}

