/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class CteProducerNode
extends PlanNode {
    private final PlanNode source;
    private final String cteId;
    private final VariableReferenceExpression rowCountVariable;
    private final List<VariableReferenceExpression> originalOutputVariables;

    @JsonCreator
    public CteProducerNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source2, @JsonProperty(value="cteId") String cteId, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="originalOutputVariables") List<VariableReferenceExpression> originalOutputVariables) {
        this(sourceLocation, id, Optional.empty(), source2, cteId, rowCountVariable, originalOutputVariables);
    }

    public CteProducerNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source2, String cteId, VariableReferenceExpression rowCountVariable, List<VariableReferenceExpression> originalOutputVariables) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.cteId = Objects.requireNonNull(cteId, "cteName must not be null");
        this.source = Objects.requireNonNull(source2, "source must not be null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable must not be null");
        this.originalOutputVariables = Objects.requireNonNull(originalOutputVariables, "originalOutputVariables must not be null");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.originalOutputVariables;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        CteProducerNode.checkArgument(newChildren.size() == 1, "expected newChildren to contain 1 node");
        return new CteProducerNode(newChildren.get(0).getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.cteId, this.rowCountVariable, this.originalOutputVariables);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new CteProducerNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.cteId, this.rowCountVariable, this.originalOutputVariables);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCteProducer(this, context);
    }

    @JsonProperty
    public String getCteId() {
        return this.cteId;
    }

    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

