/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.common.predicate.TupleDomain;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.IndexHandle;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.TableHandle;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IndexSourceNode
extends PlanNode {
    private final IndexHandle indexHandle;
    private final TableHandle tableHandle;
    private final Set<VariableReferenceExpression> lookupVariables;
    private final List<VariableReferenceExpression> outputVariables;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> currentConstraint;

    @JsonCreator
    public IndexSourceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="indexHandle") IndexHandle indexHandle, @JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="lookupVariables") Set<VariableReferenceExpression> lookupVariables, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments, @JsonProperty(value="currentConstraint") TupleDomain<ColumnHandle> currentConstraint) {
        this(sourceLocation, id, Optional.empty(), indexHandle, tableHandle, lookupVariables, outputVariables, assignments, currentConstraint);
    }

    public IndexSourceNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, IndexHandle indexHandle, TableHandle tableHandle, Set<VariableReferenceExpression> lookupVariables, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.indexHandle = Objects.requireNonNull(indexHandle, "indexHandle is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.lookupVariables = Collections.unmodifiableSet(new LinkedHashSet(Objects.requireNonNull(lookupVariables, "lookupVariables is null")));
        this.outputVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputVariables, "outputVariables is null")));
        this.assignments = Collections.unmodifiableMap(new LinkedHashMap<VariableReferenceExpression, ColumnHandle>(Objects.requireNonNull(assignments, "assignments is null")));
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "effectiveTupleDomain is null");
        Utils.checkArgument(!lookupVariables.isEmpty(), "lookupVariables is empty", new Object[0]);
        Utils.checkArgument(!outputVariables.isEmpty(), "outputVariables is empty", new Object[0]);
        Utils.checkArgument(assignments.keySet().containsAll(lookupVariables), "Assignments do not include all lookup variables", new Object[0]);
        Utils.checkArgument(outputVariables.containsAll(lookupVariables), "Lookup variables need to be part of the output variables", new Object[0]);
    }

    @JsonProperty
    public IndexHandle getIndexHandle() {
        return this.indexHandle;
    }

    @JsonProperty
    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getLookupVariables() {
        return this.lookupVariables;
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        return this.currentConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitIndexSource(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.isEmpty(), "newChildren is not empty", new Object[0]);
        return this;
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new IndexSourceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.indexHandle, this.tableHandle, this.lookupVariables, this.outputVariables, this.assignments, this.currentConstraint);
    }
}

