/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.plan.ExchangeEncoding;
import com.facebook.presto.jdbc.internal.spi.plan.Partitioning;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PartitioningScheme {
    private final Partitioning partitioning;
    private final List<VariableReferenceExpression> outputLayout;
    private final Optional<VariableReferenceExpression> hashColumn;
    private final boolean replicateNullsAndAny;
    private final boolean scaleWriters;
    private final ExchangeEncoding encoding;
    private final Optional<int[]> bucketToPartition;

    public PartitioningScheme(Partitioning partitioning, List<VariableReferenceExpression> outputLayout, boolean scaleWriters) {
        this(partitioning, outputLayout, Optional.empty(), false, scaleWriters, ExchangeEncoding.COLUMNAR, Optional.empty());
    }

    public PartitioningScheme(Partitioning partitioning, List<VariableReferenceExpression> outputLayout) {
        this(partitioning, outputLayout, Optional.empty(), false, false, ExchangeEncoding.COLUMNAR, Optional.empty());
    }

    public PartitioningScheme(Partitioning partitioning, List<VariableReferenceExpression> outputLayout, Optional<VariableReferenceExpression> hashColumn) {
        this(partitioning, outputLayout, hashColumn, false, false, ExchangeEncoding.COLUMNAR, Optional.empty());
    }

    @JsonCreator
    public PartitioningScheme(@JsonProperty(value="partitioning") Partitioning partitioning, @JsonProperty(value="outputLayout") List<VariableReferenceExpression> outputLayout, @JsonProperty(value="hashColumn") Optional<VariableReferenceExpression> hashColumn, @JsonProperty(value="replicateNullsAndAny") boolean replicateNullsAndAny, @JsonProperty(value="scaleWriters") boolean scaleWriters, @JsonProperty(value="encoding") ExchangeEncoding encoding, @JsonProperty(value="bucketToPartition") Optional<int[]> bucketToPartition) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.outputLayout = Collections.unmodifiableList(Objects.requireNonNull(outputLayout, "outputLayout is null"));
        Set<VariableReferenceExpression> columns = partitioning.getVariableReferences();
        Set<VariableReferenceExpression> outputLayoutSet = Collections.unmodifiableSet(new HashSet<VariableReferenceExpression>(outputLayout));
        Utils.checkArgument(outputLayoutSet.containsAll(columns), String.format("Output layout (%s) don't include all partition columns (%s)", outputLayout, columns), new Object[0]);
        this.hashColumn = Objects.requireNonNull(hashColumn, "hashColumn is null");
        hashColumn.ifPresent(column -> Utils.checkArgument(outputLayout.contains(column), String.format("Output layout (%s) don't include hash column (%s)", outputLayout, column), new Object[0]));
        Utils.checkArgument(!replicateNullsAndAny || columns.size() <= 1, "Must have at most one partitioning column when nullPartition is REPLICATE.", new Object[0]);
        this.replicateNullsAndAny = replicateNullsAndAny;
        this.scaleWriters = scaleWriters;
        this.encoding = Objects.requireNonNull(encoding, "encoding is null");
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
    }

    @JsonProperty
    public Partitioning getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashColumn() {
        return this.hashColumn;
    }

    @JsonProperty
    public boolean isReplicateNullsAndAny() {
        return this.replicateNullsAndAny;
    }

    @JsonProperty
    public ExchangeEncoding getEncoding() {
        return this.encoding;
    }

    @JsonProperty
    public boolean isScaleWriters() {
        return this.scaleWriters;
    }

    @JsonProperty
    public Optional<int[]> getBucketToPartition() {
        return this.bucketToPartition;
    }

    public PartitioningScheme withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PartitioningScheme(this.partitioning, this.outputLayout, this.hashColumn, this.replicateNullsAndAny, this.scaleWriters, this.encoding, bucketToPartition);
    }

    public PartitioningScheme withRowWiseEncoding() {
        return new PartitioningScheme(this.partitioning, this.outputLayout, this.hashColumn, this.replicateNullsAndAny, this.scaleWriters, ExchangeEncoding.ROW_WISE, this.bucketToPartition);
    }

    public boolean isSingleOrBroadcastOrArbitrary() {
        return this.partitioning.isSingleOrBroadcastOrArbitrary();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningScheme that = (PartitioningScheme)o;
        return Objects.equals(this.partitioning, that.partitioning) && Objects.equals(this.outputLayout, that.outputLayout) && this.replicateNullsAndAny == that.replicateNullsAndAny && this.scaleWriters == that.scaleWriters && this.encoding == that.encoding && Objects.equals(this.bucketToPartition, that.bucketToPartition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitioning, this.outputLayout, this.replicateNullsAndAny, this.encoding, this.scaleWriters, this.bucketToPartition});
    }

    public String toString() {
        String sb = "ConnectorTableMetadata{partitioning=" + this.partitioning + ", outputLayout=" + this.outputLayout + ", hashChannel=" + this.hashColumn + ", replicateNullsAndAny=" + this.replicateNullsAndAny + ", scaleWriters=" + this.scaleWriters + ", encoding=" + (Object)((Object)this.encoding) + ", bucketToPartition=" + this.bucketToPartition + '}';
        return sb;
    }
}

