/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.AbstractJoinNode;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class SemiJoinNode
extends AbstractJoinNode {
    private final PlanNode source;
    private final PlanNode filteringSource;
    private final VariableReferenceExpression sourceJoinVariable;
    private final VariableReferenceExpression filteringSourceJoinVariable;
    private final VariableReferenceExpression semiJoinOutput;
    private final Optional<VariableReferenceExpression> sourceHashVariable;
    private final Optional<VariableReferenceExpression> filteringSourceHashVariable;
    private final Optional<DistributionType> distributionType;
    private final Map<String, VariableReferenceExpression> dynamicFilters;

    @JsonCreator
    public SemiJoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source2, @JsonProperty(value="filteringSource") PlanNode filteringSource, @JsonProperty(value="sourceJoinVariable") VariableReferenceExpression sourceJoinVariable, @JsonProperty(value="filteringSourceJoinVariable") VariableReferenceExpression filteringSourceJoinVariable, @JsonProperty(value="semiJoinOutput") VariableReferenceExpression semiJoinOutput, @JsonProperty(value="sourceHashVariable") Optional<VariableReferenceExpression> sourceHashVariable, @JsonProperty(value="filteringSourceHashVariable") Optional<VariableReferenceExpression> filteringSourceHashVariable, @JsonProperty(value="distributionType") Optional<DistributionType> distributionType, @JsonProperty(value="dynamicFilters") Map<String, VariableReferenceExpression> dynamicFilters) {
        this(sourceLocation, id, Optional.empty(), source2, filteringSource, sourceJoinVariable, filteringSourceJoinVariable, semiJoinOutput, sourceHashVariable, filteringSourceHashVariable, distributionType, dynamicFilters);
    }

    public SemiJoinNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source2, PlanNode filteringSource, VariableReferenceExpression sourceJoinVariable, VariableReferenceExpression filteringSourceJoinVariable, VariableReferenceExpression semiJoinOutput, Optional<VariableReferenceExpression> sourceHashVariable, Optional<VariableReferenceExpression> filteringSourceHashVariable, Optional<DistributionType> distributionType, Map<String, VariableReferenceExpression> dynamicFilters) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source2, "source is null");
        this.filteringSource = Objects.requireNonNull(filteringSource, "filteringSource is null");
        this.sourceJoinVariable = Objects.requireNonNull(sourceJoinVariable, "sourceJoinVariable is null");
        this.filteringSourceJoinVariable = Objects.requireNonNull(filteringSourceJoinVariable, "filteringSourceJoinVariable is null");
        this.semiJoinOutput = Objects.requireNonNull(semiJoinOutput, "semiJoinOutput is null");
        this.sourceHashVariable = Objects.requireNonNull(sourceHashVariable, "sourceHashVariable is null");
        this.filteringSourceHashVariable = Objects.requireNonNull(filteringSourceHashVariable, "filteringSourceHashVariable is null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        this.dynamicFilters = Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
        Utils.checkArgument(source2.getOutputVariables().contains(sourceJoinVariable), "Source does not contain join symbol", new Object[0]);
        Utils.checkArgument(filteringSource.getOutputVariables().contains(filteringSourceJoinVariable), "Filtering source does not contain filtering join symbol", new Object[0]);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public PlanNode getProbe() {
        return this.source;
    }

    @JsonProperty
    public PlanNode getFilteringSource() {
        return this.filteringSource;
    }

    @Override
    public PlanNode getBuild() {
        return this.filteringSource;
    }

    @JsonProperty
    public VariableReferenceExpression getSourceJoinVariable() {
        return this.sourceJoinVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getFilteringSourceJoinVariable() {
        return this.filteringSourceJoinVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getSemiJoinOutput() {
        return this.semiJoinOutput;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getSourceHashVariable() {
        return this.sourceHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getFilteringSourceHashVariable() {
        return this.filteringSourceHashVariable;
    }

    @JsonProperty
    public Optional<DistributionType> getDistributionType() {
        return this.distributionType;
    }

    @Override
    @JsonProperty
    public Map<String, VariableReferenceExpression> getDynamicFilters() {
        return this.dynamicFilters;
    }

    @Override
    public List<PlanNode> getSources() {
        ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
        sources.add(this.source);
        sources.add(this.filteringSource);
        return Collections.unmodifiableList(sources);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        ArrayList<VariableReferenceExpression> outputVariables = new ArrayList<VariableReferenceExpression>();
        outputVariables.addAll(this.source.getOutputVariables());
        outputVariables.add(this.semiJoinOutput);
        return Collections.unmodifiableList(outputVariables);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSemiJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 2, "expected newChildren to contain 2 nodes", new Object[0]);
        return new SemiJoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), newChildren.get(1), this.sourceJoinVariable, this.filteringSourceJoinVariable, this.semiJoinOutput, this.sourceHashVariable, this.filteringSourceHashVariable, this.distributionType, this.dynamicFilters);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new SemiJoinNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.filteringSource, this.sourceJoinVariable, this.filteringSourceJoinVariable, this.semiJoinOutput, this.sourceHashVariable, this.filteringSourceHashVariable, this.distributionType, this.dynamicFilters);
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getSemiJoinProperties(this);
    }

    public SemiJoinNode withDistributionType(DistributionType distributionType) {
        return new SemiJoinNode(this.getSourceLocation(), this.getId(), this.source, this.filteringSource, this.sourceJoinVariable, this.filteringSourceJoinVariable, this.semiJoinOutput, this.sourceHashVariable, this.filteringSourceHashVariable, Optional.of(distributionType), this.dynamicFilters);
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }
}

