/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.plan.AggregationNode;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticAggregations {
    private final List<VariableReferenceExpression> outputVariables;
    private final Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations;
    private final List<VariableReferenceExpression> groupingVariables;

    @JsonCreator
    public StatisticAggregations(@JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="aggregations") Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations, @JsonProperty(value="groupingVariables") List<VariableReferenceExpression> groupingVariables) {
        this.outputVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputVariables, "outputVariables is null")));
        this.aggregations = Collections.unmodifiableMap(new LinkedHashMap<VariableReferenceExpression, AggregationNode.Aggregation>(Objects.requireNonNull(aggregations, "aggregations is null")));
        this.groupingVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(groupingVariables, "groupingVariables is null")));
        Utils.checkArgument(outputVariables.size() == aggregations.size(), "outputVariables and aggregations' sizes are different", new Object[0]);
    }

    public StatisticAggregations(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations, List<VariableReferenceExpression> groupingVariables) {
        this.aggregations = Collections.unmodifiableMap(new LinkedHashMap<VariableReferenceExpression, AggregationNode.Aggregation>(Objects.requireNonNull(aggregations, "aggregations is null")));
        this.groupingVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(groupingVariables, "groupingVariables is null")));
        this.outputVariables = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(aggregations.keySet()));
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, AggregationNode.Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getGroupingVariables() {
        return this.groupingVariables;
    }

    public static class Parts {
        private final Optional<StatisticAggregations> finalAggregation;
        private final Optional<StatisticAggregations> intermediateAggregation;
        private final StatisticAggregations partialAggregation;

        public Parts(Optional<StatisticAggregations> finalAggregation, Optional<StatisticAggregations> intermediateAggregation, StatisticAggregations partialAggregation) {
            this.finalAggregation = Objects.requireNonNull(finalAggregation, "finalAggregation is null");
            this.intermediateAggregation = Objects.requireNonNull(intermediateAggregation, "intermediateAggregation is null");
            Utils.checkArgument(finalAggregation.isPresent() ^ intermediateAggregation.isPresent(), "only final or only intermediate aggregation is expected to be present", new Object[0]);
            this.partialAggregation = Objects.requireNonNull(partialAggregation, "partialAggregation is null");
        }

        public StatisticAggregations getFinalAggregation() {
            return this.finalAggregation.orElseThrow(() -> new IllegalStateException("finalAggregation is not present"));
        }

        public StatisticAggregations getIntermediateAggregation() {
            return this.intermediateAggregation.orElseThrow(() -> new IllegalStateException("intermediateAggregation is not present"));
        }

        public StatisticAggregations getPartialAggregation() {
            return this.partialAggregation;
        }
    }
}

