/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.common.RuntimeStats;
import com.facebook.presto.jdbc.internal.common.resourceGroups.QueryType;
import com.facebook.presto.jdbc.internal.spi.QueryId;
import com.facebook.presto.jdbc.internal.spi.WarningCollector;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AccessControlContext {
    private final QueryId queryId;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final Optional<String> source;
    private final WarningCollector warningCollector;
    private final RuntimeStats runtimeStats;
    private final Optional<QueryType> queryType;
    private final Optional<String> catalog;
    private final Optional<String> schema;

    public AccessControlContext(QueryId queryId, Optional<String> clientInfo, Set<String> clientTags, Optional<String> source2, WarningCollector warningCollector, RuntimeStats runtimeStats, Optional<QueryType> queryType, Optional<String> catalog, Optional<String> schema) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.source = Objects.requireNonNull(source2, "source is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.clientInfo, this.clientTags, this.source, this.queryType, this.catalog, this.schema);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessControlContext other = (AccessControlContext)obj;
        return Objects.equals(this.queryId, other.queryId) && Objects.equals(this.clientInfo, other.clientInfo) && Objects.equals(this.clientTags, other.clientTags) && Objects.equals(this.source, other.source) && Objects.equals(this.queryType, other.queryType) && Objects.equals(this.catalog, other.catalog) && Objects.equals(this.schema, other.schema);
    }
}

