package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.NullValueProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableCollection.Builder;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMultiset;

public class ImmutableMultisetDeserializer extends GuavaImmutableCollectionDeserializer<ImmutableMultiset<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableMultisetDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    protected Builder<Object> createBuilder() {
        return ImmutableMultiset.builder();
    }

    @Override
    public GuavaCollectionDeserializer<ImmutableMultiset<Object>> withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableMultisetDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    protected ImmutableMultiset<Object> _createEmpty(DeserializationContext ctxt) {
        return ImmutableMultiset.of();
    }

    @Override
    protected ImmutableMultiset<Object> _createWithSingleElement(DeserializationContext ctxt, Object value) {
        return ImmutableMultiset.of(value);
    }
}
