package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.NullValueProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableCollection.Builder;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSortedMultiset;

public class ImmutableSortedMultisetDeserializer extends GuavaImmutableCollectionDeserializer<ImmutableSortedMultiset<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableSortedMultisetDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    public GuavaCollectionDeserializer<ImmutableSortedMultiset<Object>> withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableSortedMultisetDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    protected Builder<Object> createBuilder() {
        /* This is suboptimal. See the considerations in ImmutableSortedSetDeserializer. */
        @SuppressWarnings({ "rawtypes", "unchecked" })
        Builder<Object> builder =  (Builder) ImmutableSortedMultiset.naturalOrder();
        return builder;
    }

    @Override
    protected ImmutableSortedMultiset<Object> _createEmpty(DeserializationContext ctxt) {
        return ImmutableSortedMultiset.of();
    }

    @Override
    protected ImmutableSortedMultiset<Object> _createWithSingleElement(DeserializationContext ctxt,
            Object value) {
        return (ImmutableSortedMultiset<Object>) createBuilder()
                .add(value)
                .build();
    }
}
