package com.facebook.presto.jdbc.internal.jackson.datatype.guava.ser;

import java.io.IOException;

import com.facebook.presto.jdbc.internal.jackson.core.JacksonException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.core.type.WritableTypeId;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeSerializer;
import com.facebook.presto.jdbc.internal.jackson.databind.ser.std.StdSerializer;

import com.facebook.presto.jdbc.internal.guava.cache.Cache;

public class CacheSerializer extends StdSerializer<Cache<?, ?>>
{
    private static final long serialVersionUID = 1L;

    public CacheSerializer() {
        super(Cache.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Cache<?, ?> value) {
        // Since we serialize all as empty, let's claim we are always empty
        return true;
    }

    @Override
    public void serialize(Cache<?, ?> value, JsonGenerator gen, SerializerProvider provider)
        throws IOException
    {
        gen.writeStartObject(value);
        _writeContents(value, gen, provider);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Cache<?, ?> value, JsonGenerator gen, SerializerProvider ctxt,
            TypeSerializer typeSer)
        throws IOException
    {
        gen.assignCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen,
                typeSer.typeId(value, JsonToken.START_OBJECT));
        _writeContents(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    // Just a stub in case we have time to implement proper (if optional) serialization
    protected void _writeContents(Cache<?, ?> value, JsonGenerator g, SerializerProvider ctxt)
        throws JacksonException
    {
    }    
}
