/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package com.facebook.presto.jdbc.internal.kotlin.jvm.internal;

import com.facebook.presto.jdbc.internal.kotlin.SinceKotlin;
import com.facebook.presto.jdbc.internal.kotlin.reflect.KCallable;
import com.facebook.presto.jdbc.internal.kotlin.reflect.KProperty1;

@SuppressWarnings({"unchecked", "rawtypes", "unused", "NullableProblems"})
public abstract class PropertyReference1 extends PropertyReference implements KProperty1 {
    public PropertyReference1() {
        super();
    }

    @SinceKotlin(version = "1.1")
    public PropertyReference1(Object receiver) {
        super(receiver);
    }

    @SinceKotlin(version = "1.4")
    public PropertyReference1(Object receiver, Class owner, String name, String signature, int flags) {
        super(receiver, owner, name, signature, flags);
    }

    @Override
    protected KCallable computeReflected() {
        return Reflection.property1(this);
    }

    @Override
    public Object invoke(Object receiver) {
        return get(receiver);
    }

    @Override
    public KProperty1.Getter getGetter() {
        return ((KProperty1) getReflected()).getGetter();
    }

    @Override
    @SinceKotlin(version = "1.1")
    public Object getDelegate(Object receiver) {
        return ((KProperty1) getReflected()).getDelegate(receiver);
    }
}
