/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.InvalidTypeDefinitionException;
import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.type.BigintEnumType;
import com.facebook.presto.jdbc.internal.common.type.DistinctTypeInfo;
import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.RowFieldName;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureBase;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.UserDefinedType;
import com.facebook.presto.jdbc.internal.common.type.VarcharEnumType;
import com.facebook.presto.jdbc.internal.common.type.VarcharType;
import com.facebook.presto.jdbc.internal.common.type.encoding.Base32;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@ThriftStruct
public class TypeSignature {
    private final TypeSignatureBase base;
    private final List<TypeSignatureParameter> parameters;
    private final boolean calculated;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_]([a-zA-Z0-9_:@])*");
    private static final Map<String, String> BASE_NAME_ALIAS_TO_CANONICAL = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> SIMPLE_TYPE_WITH_SPACES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final String BIGINT_ENUM_PREFIX = "BigintEnum".toLowerCase(Locale.ENGLISH);
    private static final Pattern ENUM_PREFIX = Pattern.compile("(varchar|bigint)enum\\(");
    private static final Pattern DISTINCT_TYPE_PREFIX = Pattern.compile("distincttype\\(");

    public TypeSignature(UserDefinedType userDefinedType) {
        this(TypeSignatureBase.of(userDefinedType), userDefinedType.getPhysicalTypeSignature().getParameters());
    }

    public TypeSignature(DistinctTypeInfo distinctTypeInfo) {
        this(TypeSignatureBase.of(distinctTypeInfo), Collections.singletonList(TypeSignatureParameter.of(distinctTypeInfo)));
    }

    public TypeSignature(QualifiedObjectName base) {
        this(TypeSignatureBase.of(base), Collections.emptyList());
    }

    public TypeSignature(String base, TypeSignatureParameter ... parameters) {
        this(base, Arrays.asList(parameters));
    }

    public TypeSignature(String base, List<TypeSignatureParameter> parameters) {
        this(TypeSignatureBase.of(base), parameters);
    }

    public TypeSignature(TypeSignatureBase typeSignatureBase, List<TypeSignatureParameter> parameters) {
        this.base = typeSignatureBase;
        TypeSignature.checkArgument(parameters != null, "parameters is null", new Object[0]);
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeSignatureParameter>(parameters));
        this.calculated = parameters.stream().anyMatch(TypeSignatureParameter::isCalculated);
    }

    @ThriftConstructor
    public TypeSignature(String signature, boolean ignore) {
        this(TypeSignature.parseTypeSignature(signature).getTypeSignatureBase(), TypeSignature.parseTypeSignature(signature).getParameters());
    }

    public TypeSignature getStandardTypeSignature() {
        return new TypeSignature(this.base.getStandardTypeBase(), this.parameters);
    }

    public TypeSignatureBase getTypeSignatureBase() {
        return this.base;
    }

    public String getBase() {
        return this.base.toString();
    }

    public List<TypeSignatureParameter> getParameters() {
        return this.parameters;
    }

    public List<TypeSignature> getTypeOrNamedTypeParametersAsTypeSignatures() {
        ArrayList<TypeSignature> result = new ArrayList<TypeSignature>();
        block4: for (TypeSignatureParameter parameter : this.parameters) {
            switch (parameter.getKind()) {
                case TYPE: {
                    result.add(parameter.getTypeSignature());
                    continue block4;
                }
                case NAMED_TYPE: {
                    result.add(parameter.getNamedTypeSignature().getTypeSignature());
                    continue block4;
                }
            }
            throw new IllegalStateException(String.format("Expected all parameters to be of kind TYPE or NAMED_TYPE but [%s] kind was found for parameter: [%s]", new Object[]{parameter.getKind(), parameter}));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public boolean isEnum() {
        return this.isBigintEnum() || this.isVarcharEnum();
    }

    public boolean isFunction() {
        return this.base.getStandardTypeBase().equals("function");
    }

    public boolean isBigintEnum() {
        return this.parameters.size() == 1 && this.parameters.get(0).isLongEnum();
    }

    public boolean isVarcharEnum() {
        return this.parameters.size() == 1 && this.parameters.get(0).isVarcharEnum();
    }

    public boolean isDistinctType() {
        return this.parameters.size() == 1 && this.parameters.get(0).isDistinctType();
    }

    public DistinctTypeInfo getDistinctTypeInfo() {
        TypeSignature.checkArgument(this.isDistinctType(), String.format("%s is not a distinct type", this), new Object[0]);
        return this.getParameters().get(0).getDistinctTypeInfo();
    }

    @JsonCreator
    public static TypeSignature parseTypeSignature(String signature) {
        return TypeSignature.parseTypeSignature(signature, new HashSet<String>());
    }

    public static TypeSignature parseTypeSignature(String signature, Set<String> literalCalculationParameters) {
        int posOfLessThan = signature.indexOf("<");
        int posOfParent = signature.indexOf("(");
        int posOfColon = signature.indexOf(":");
        if (posOfLessThan < 0 && posOfParent < 0 && posOfColon < 0) {
            if (signature.equalsIgnoreCase("varchar")) {
                return VarcharType.createUnboundedVarcharType().getTypeSignature();
            }
            TypeSignature.checkArgument(!literalCalculationParameters.contains(signature), "Bad type signature: '%s'", signature);
            return new TypeSignature(TypeSignature.canonicalizeBaseName(signature), new ArrayList<TypeSignatureParameter>());
        }
        String lowerCaseSignature = signature.toLowerCase(Locale.ENGLISH);
        if (posOfColon > 0) {
            if (posOfLessThan < 0 && posOfParent < 0) {
                return new TypeSignature(TypeSignature.canonicalizeBaseName(signature), new TypeSignatureParameter[0]);
            }
            int startOfParams = Integer.min(posOfLessThan < 0 ? Integer.MAX_VALUE : posOfLessThan, posOfParent < 0 ? Integer.MAX_VALUE : posOfParent);
            if (posOfColon < startOfParams) {
                return new TypeSignature(signature.substring(0, startOfParams), TypeSignature.parseTypeSignature(signature.substring(posOfColon + 1)).getParameters());
            }
        }
        if (lowerCaseSignature.startsWith("row(")) {
            return TypeSignature.parseRowTypeSignature(signature, literalCalculationParameters);
        }
        Set<Integer> enumMapStartIndices = TypeSignature.findEnumMapStartIndices(lowerCaseSignature);
        Set<Integer> distinctTypeStartIndices = TypeSignature.findDistinctTypeStartIndices(lowerCaseSignature);
        HashMap<Integer, EnumMapParsingData> parsedEnumMaps = new HashMap<Integer, EnumMapParsingData>();
        HashMap<Integer, DistinctTypeParsingData> parsedDistinctTypes = new HashMap<Integer, DistinctTypeParsingData>();
        String baseName = null;
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>();
        int parameterStart = -1;
        int bracketCount = 0;
        int parameterEnd = -1;
        for (int i = 0; i < signature.length(); ++i) {
            if (i < parameterEnd) continue;
            char c = signature.charAt(i);
            if (c == '(' || c == '<') {
                if (bracketCount == 0) {
                    TypeSignature.verify(baseName == null, "Expected baseName to be null");
                    TypeSignature.verify(parameterStart == -1, "Expected parameter start to be -1");
                    baseName = TypeSignature.canonicalizeBaseName(signature.substring(0, i));
                    TypeSignature.checkArgument(!literalCalculationParameters.contains(baseName), "Bad type signature: '%s'", signature);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == ')' || c == '>') {
                TypeSignature.checkArgument(--bracketCount >= 0, "Bad type signature: '%s'", signature);
                if (bracketCount != 0) continue;
                TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
                parameters.add(TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i, literalCalculationParameters, parsedEnumMaps, parsedDistinctTypes));
                parameterStart = i + 1;
                if (i != signature.length() - 1) continue;
                return new TypeSignature(baseName, parameters);
            }
            if (enumMapStartIndices.contains(i)) {
                EnumMapParsingData enumMapParsingData = TypeSignature.parseEnumMap(lowerCaseSignature, i);
                parameterEnd = enumMapParsingData.mapEndIndex;
                parsedEnumMaps.put(i, enumMapParsingData);
                continue;
            }
            if (distinctTypeStartIndices.contains(i)) {
                DistinctTypeParsingData distinctTypeParsingData = DistinctTypeParsingData.parse(lowerCaseSignature, i);
                parameterEnd = distinctTypeParsingData.endIndex;
                parsedDistinctTypes.put(i, distinctTypeParsingData);
                continue;
            }
            if (c != ',' || bracketCount != 1) continue;
            TypeSignature.checkArgument(parameterStart >= 0, "Bad type signature: '%s'", signature);
            parameters.add(TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i, literalCalculationParameters, parsedEnumMaps, parsedDistinctTypes));
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    private static Set<Integer> findEnumMapStartIndices(String signature) {
        HashSet<Integer> indices = new HashSet<Integer>();
        Matcher enumMatcher = ENUM_PREFIX.matcher(signature);
        while (enumMatcher.find()) {
            indices.add(enumMatcher.end());
        }
        return indices;
    }

    private static Set<Integer> findDistinctTypeStartIndices(String signature) {
        HashSet<Integer> indices = new HashSet<Integer>();
        Matcher enumMatcher = DISTINCT_TYPE_PREFIX.matcher(signature);
        while (enumMatcher.find()) {
            indices.add(enumMatcher.end());
        }
        return indices;
    }

    private static EnumMapParsingData parseEnumMap(String signature, int startIndex) {
        EnumMapParsingState state = EnumMapParsingState.EXPECT_KEY;
        boolean isBigintEnum = signature.startsWith(BIGINT_ENUM_PREFIX, startIndex - BIGINT_ENUM_PREFIX.length() - 1);
        int openBracketIndex = signature.indexOf("{", startIndex);
        String typeName = signature.substring(startIndex, openBracketIndex);
        String key = null;
        StringBuilder keyOrValue = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = openBracketIndex + 1; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (state == EnumMapParsingState.IN_KEY_ESCAPE) {
                state = EnumMapParsingState.IN_KEY;
                keyOrValue.append(c);
            }
            if (state == EnumMapParsingState.IN_STR_VALUE_ESCAPE) {
                state = EnumMapParsingState.IN_STR_VALUE;
                keyOrValue.append(c);
                continue;
            }
            if (c == '\"') {
                if (state == EnumMapParsingState.EXPECT_KEY) {
                    state = EnumMapParsingState.IN_KEY;
                    continue;
                }
                if (state == EnumMapParsingState.EXPECT_VALUE) {
                    if (isBigintEnum) {
                        throw new IllegalStateException("Unexpected varchar value in numeric enum signature");
                    }
                    state = EnumMapParsingState.IN_STR_VALUE;
                    continue;
                }
                if ((state == EnumMapParsingState.IN_KEY || state == EnumMapParsingState.IN_STR_VALUE) && i + 1 < signature.length() && signature.charAt(i + 1) == '\"') {
                    state = state == EnumMapParsingState.IN_KEY ? EnumMapParsingState.IN_KEY_ESCAPE : EnumMapParsingState.IN_STR_VALUE_ESCAPE;
                    continue;
                }
                if (state == EnumMapParsingState.IN_KEY) {
                    state = EnumMapParsingState.EXPECT_COLON;
                    continue;
                }
                if (state == EnumMapParsingState.IN_STR_VALUE) {
                    state = EnumMapParsingState.EXPECT_COMMA_OR_CLOSING_BRACKET;
                    continue;
                }
                throw new IllegalStateException("Cannot parse enum signature");
            }
            if (state == EnumMapParsingState.IN_KEY || state == EnumMapParsingState.IN_STR_VALUE) {
                keyOrValue.append(c);
                continue;
            }
            if (c == ':' && state == EnumMapParsingState.EXPECT_COLON) {
                key = keyOrValue.toString();
                keyOrValue = new StringBuilder();
                state = EnumMapParsingState.EXPECT_VALUE;
                continue;
            }
            if ((Character.isDigit(c) || c == '-') && state == EnumMapParsingState.EXPECT_VALUE) {
                if (!isBigintEnum) {
                    throw new IllegalStateException("Unexpected numeric value in varchar enum signature");
                }
                state = EnumMapParsingState.IN_NUM_VALUE;
                keyOrValue.append(c);
                continue;
            }
            if (Character.isDigit(c) && state == EnumMapParsingState.IN_NUM_VALUE) {
                keyOrValue.append(c);
                continue;
            }
            if (!(c != ',' && c != '}' || state != EnumMapParsingState.EXPECT_COMMA_OR_CLOSING_BRACKET && state != EnumMapParsingState.IN_NUM_VALUE)) {
                if (key == null) {
                    throw new IllegalStateException("Cannot parse enum signature");
                }
                map.put(key, keyOrValue.toString());
                if (c == '}') {
                    return new EnumMapParsingData(i, typeName, map, isBigintEnum);
                }
                key = null;
                keyOrValue = new StringBuilder();
                state = EnumMapParsingState.EXPECT_KEY;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new IllegalStateException("Cannot parse enum signature");
        }
        throw new IllegalStateException("Cannot parse enum signature");
    }

    private static TypeSignature parseRowTypeSignature(String signature, Set<String> literalParameters) {
        TypeSignature.checkArgument(signature.toLowerCase(Locale.ENGLISH).startsWith("row("), "Not a row type signature: '%s'", signature);
        RowTypeSignatureParsingState state = RowTypeSignatureParsingState.START_OF_FIELD;
        int bracketLevel = 1;
        int tokenStart = -1;
        String delimitedColumnName = null;
        ArrayList<TypeSignatureParameter> fields = new ArrayList<TypeSignatureParameter>();
        HashSet<String> distinctFieldNames = new HashSet<String>();
        block8: for (int i = "row".length() + 1; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            switch (state) {
                case START_OF_FIELD: {
                    if (c == '\"') {
                        state = RowTypeSignatureParsingState.DELIMITED_NAME;
                        tokenStart = i;
                        continue block8;
                    }
                    if (TypeSignature.isValidStartOfIdentifier(c)) {
                        state = RowTypeSignatureParsingState.TYPE_OR_NAMED_TYPE;
                        tokenStart = i;
                        continue block8;
                    }
                    TypeSignature.checkArgument(c == ' ', "Bad type signature: '%s'", signature);
                    continue block8;
                }
                case DELIMITED_NAME: {
                    if (c != '\"') continue block8;
                    if (i + 1 < signature.length() && signature.charAt(i + 1) == '\"') {
                        state = RowTypeSignatureParsingState.DELIMITED_NAME_ESCAPED;
                        continue block8;
                    }
                    TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                    delimitedColumnName = signature.substring(tokenStart + 1, i);
                    tokenStart = i + 1;
                    state = RowTypeSignatureParsingState.TYPE;
                    continue block8;
                }
                case DELIMITED_NAME_ESCAPED: {
                    TypeSignature.verify(c == '\"', "Expect quote after escape");
                    state = RowTypeSignatureParsingState.DELIMITED_NAME;
                    continue block8;
                }
                case TYPE_OR_NAMED_TYPE: {
                    TypeSignatureParameter parameter;
                    if (c == '(') {
                        ++bracketLevel;
                        continue block8;
                    }
                    if (c == ')' && bracketLevel > 1) {
                        --bracketLevel;
                        continue block8;
                    }
                    if (c == ')') {
                        TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                        parameter = TypeSignature.parseTypeOrNamedType(signature.substring(tokenStart, i).trim(), literalParameters);
                        parameter.getNamedTypeSignature().getName().ifPresent(fieldName -> TypeSignature.checkDuplicateAndAdd(distinctFieldNames, fieldName));
                        fields.add(parameter);
                        tokenStart = -1;
                        state = RowTypeSignatureParsingState.FINISHED;
                        continue block8;
                    }
                    if (c != ',' || bracketLevel != 1) continue block8;
                    TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                    parameter = TypeSignature.parseTypeOrNamedType(signature.substring(tokenStart, i).trim(), literalParameters);
                    parameter.getNamedTypeSignature().getName().ifPresent(fieldName -> TypeSignature.checkDuplicateAndAdd(distinctFieldNames, fieldName));
                    fields.add(parameter);
                    tokenStart = -1;
                    state = RowTypeSignatureParsingState.START_OF_FIELD;
                    continue block8;
                }
                case TYPE: {
                    if (c == '(') {
                        ++bracketLevel;
                        continue block8;
                    }
                    if (c == ')' && bracketLevel > 1) {
                        --bracketLevel;
                        continue block8;
                    }
                    if (c == ')') {
                        TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                        TypeSignature.verify(delimitedColumnName != null, "Expect delimitedColumnName to be non-null");
                        TypeSignature.checkDuplicateAndAdd(distinctFieldNames, delimitedColumnName);
                        fields.add(TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(delimitedColumnName, true)), TypeSignature.parseTypeSignature(signature.substring(tokenStart, i).trim(), literalParameters))));
                        delimitedColumnName = null;
                        tokenStart = -1;
                        state = RowTypeSignatureParsingState.FINISHED;
                        continue block8;
                    }
                    if (c != ',' || bracketLevel != 1) continue block8;
                    TypeSignature.verify(tokenStart >= 0, "Expect tokenStart to be non-negative");
                    TypeSignature.verify(delimitedColumnName != null, "Expect delimitedColumnName to be non-null");
                    TypeSignature.checkDuplicateAndAdd(distinctFieldNames, delimitedColumnName);
                    fields.add(TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(delimitedColumnName, true)), TypeSignature.parseTypeSignature(signature.substring(tokenStart, i).trim(), literalParameters))));
                    delimitedColumnName = null;
                    tokenStart = -1;
                    state = RowTypeSignatureParsingState.START_OF_FIELD;
                    continue block8;
                }
                case FINISHED: {
                    throw new IllegalStateException(String.format("Bad type signature: '%s'", signature));
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected RowTypeSignatureParsingState: %s", new Object[]{state}));
                }
            }
        }
        TypeSignature.checkArgument(state == RowTypeSignatureParsingState.FINISHED, "Bad type signature: '%s'", signature);
        return new TypeSignature(signature.substring(0, "row".length()), fields);
    }

    private static void checkDuplicateAndAdd(Set<String> fieldNames, String fieldName) {
        if (!fieldNames.add(fieldName)) {
            throw new InvalidTypeDefinitionException("Duplicate field: " + fieldName);
        }
    }

    private static TypeSignatureParameter parseTypeOrNamedType(String typeOrNamedType, Set<String> literalParameters) {
        int split = typeOrNamedType.indexOf(32);
        if (split == -1 || SIMPLE_TYPE_WITH_SPACES.contains(typeOrNamedType)) {
            return TypeSignatureParameter.of(new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature(typeOrNamedType, literalParameters)));
        }
        String firstPart = typeOrNamedType.substring(0, split);
        if (IDENTIFIER_PATTERN.matcher(firstPart).matches()) {
            return TypeSignatureParameter.of(new NamedTypeSignature(Optional.of(new RowFieldName(firstPart, false)), TypeSignature.parseTypeSignature(typeOrNamedType.substring(split + 1).trim(), literalParameters)));
        }
        return TypeSignatureParameter.of(new NamedTypeSignature(Optional.empty(), TypeSignature.parseTypeSignature(typeOrNamedType, literalParameters)));
    }

    private static TypeSignatureParameter parseTypeSignatureParameter(String signature, int begin, int end, Set<String> literalCalculationParameters, Map<Integer, EnumMapParsingData> parsedEnumMaps, Map<Integer, DistinctTypeParsingData> parsedDistinctTypes) {
        String parameterName = signature.substring(begin, end).trim();
        if (Character.isDigit(parameterName.charAt(0))) {
            return TypeSignatureParameter.of(Long.parseLong(parameterName));
        }
        if (literalCalculationParameters.contains(parameterName)) {
            return TypeSignatureParameter.of(parameterName);
        }
        if (parsedEnumMaps.containsKey(begin)) {
            if (!parameterName.endsWith("}")) {
                throw new IllegalStateException("Cannot parse enum signature");
            }
            EnumMapParsingData enumMapData = parsedEnumMaps.get(begin);
            if (enumMapData.isBigintEnum) {
                return TypeSignatureParameter.of(enumMapData.getLongEnumMap());
            }
            return TypeSignatureParameter.of(enumMapData.getVarcharEnumMap());
        }
        if (parsedDistinctTypes.containsKey(begin)) {
            if (!parameterName.endsWith("}")) {
                throw new IllegalStateException(String.format("Cannot parse distinct type signature (%s), doesn't end with '}'", parameterName));
            }
            return TypeSignatureParameter.of(parsedDistinctTypes.get(begin).distinctType);
        }
        return TypeSignatureParameter.of(TypeSignature.parseTypeSignature(parameterName, literalCalculationParameters));
    }

    private static boolean isValidStartOfIdentifier(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    @JsonValue
    @ThriftField(value=1, name="signature")
    public String toString() {
        String baseString = this.base.toString();
        if (this.parameters.isEmpty()) {
            return baseString;
        }
        if (baseString.equalsIgnoreCase("varchar") && this.parameters.size() == 1 && this.parameters.get(0).isLongLiteral() && this.parameters.get(0).getLongLiteral() == Integer.MAX_VALUE) {
            return baseString;
        }
        StringBuilder typeName = new StringBuilder(baseString);
        typeName.append("(").append(this.parameters.get(0));
        for (int i = 1; i < this.parameters.size(); ++i) {
            typeName.append(",").append(this.parameters.get(i));
        }
        typeName.append(")");
        return typeName.toString();
    }

    @ThriftField(value=2)
    public boolean getIgnore() {
        return true;
    }

    private static void checkArgument(boolean argument, String format, Object ... args2) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args2));
        }
    }

    private static void verify(boolean argument, String message) {
        if (!argument) {
            throw new AssertionError((Object)message);
        }
    }

    private static String canonicalizeBaseName(String baseName) {
        String canonicalBaseName = BASE_NAME_ALIAS_TO_CANONICAL.get(baseName);
        if (canonicalBaseName == null) {
            return baseName;
        }
        return canonicalBaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignature other = (TypeSignature)o;
        return Objects.equals(this.base, other.base) && Objects.equals(this.parameters, other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.parameters);
    }

    static {
        BASE_NAME_ALIAS_TO_CANONICAL.put("int", "integer");
        SIMPLE_TYPE_WITH_SPACES.add("time with time zone");
        SIMPLE_TYPE_WITH_SPACES.add("timestamp with time zone");
        SIMPLE_TYPE_WITH_SPACES.add("interval day to second");
        SIMPLE_TYPE_WITH_SPACES.add("interval year to month");
        SIMPLE_TYPE_WITH_SPACES.add("double precision");
    }

    private static class EnumMapParsingData {
        final int mapEndIndex;
        private final String typeName;
        private final Map<String, String> map;
        private final boolean isBigintEnum;

        EnumMapParsingData(int mapEndIndex, String typeName, Map<String, String> map, boolean isBigintEnum) {
            this.mapEndIndex = mapEndIndex;
            this.typeName = typeName;
            this.map = map;
            this.isBigintEnum = isBigintEnum;
        }

        BigintEnumType.LongEnumMap getLongEnumMap() {
            TypeSignature.checkArgument(this.isBigintEnum, "Invalid enum map format", new Object[0]);
            return new BigintEnumType.LongEnumMap(this.typeName, this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Long.parseLong((String)e.getValue()))));
        }

        VarcharEnumType.VarcharEnumMap getVarcharEnumMap() {
            TypeSignature.checkArgument(!this.isBigintEnum, "Invalid enum map format", new Object[0]);
            Base32 base32 = new Base32();
            return new VarcharEnumType.VarcharEnumMap(this.typeName, this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new String(base32.decode(((String)e.getValue()).toUpperCase(Locale.ENGLISH))))));
        }
    }

    private static class DistinctTypeParsingData {
        private final int endIndex;
        private final DistinctTypeInfo distinctType;

        private DistinctTypeParsingData(int endIndex, DistinctTypeInfo distinctType) {
            this.endIndex = endIndex;
            this.distinctType = distinctType;
        }

        private static Optional<QualifiedObjectName> parseParentName(String s) {
            return s.equals("null") ? Optional.empty() : Optional.of(QualifiedObjectName.valueOf(s));
        }

        private static DistinctTypeParsingData parse(String signature, int startIndex) {
            int openBracketIndex = signature.indexOf("{", startIndex);
            if (openBracketIndex == -1) {
                throw new IllegalStateException(String.format("Cannot parse distinct type definition(%s), expected '{' after position %s", signature, startIndex));
            }
            QualifiedObjectName name = QualifiedObjectName.valueOf(signature.substring(startIndex, openBracketIndex));
            int firstCommaIndex = signature.indexOf(", ", openBracketIndex);
            if (firstCommaIndex == -1) {
                throw new IllegalStateException(String.format("Cannot parse distinct type definition(%s), expected ',' after position %s", signature, openBracketIndex));
            }
            TypeSignature baseType = TypeSignature.parseTypeSignature(signature.substring(openBracketIndex + 1, firstCommaIndex));
            int secondCommaIndex = signature.indexOf(", ", firstCommaIndex + 2);
            if (secondCommaIndex == -1) {
                throw new IllegalStateException(String.format("Cannot parse distinct type definition(%s), expected ',' after position %s", signature, secondCommaIndex));
            }
            boolean isOrderable = Boolean.parseBoolean(signature.substring(firstCommaIndex + 2, secondCommaIndex));
            int thirdCommaIndex = signature.indexOf(", [", secondCommaIndex + 2);
            if (thirdCommaIndex == -1) {
                throw new IllegalStateException(String.format("Cannot parse distinct type definition(%s), expected '[' after position %s", signature, secondCommaIndex));
            }
            Optional<QualifiedObjectName> topMostAncestor = DistinctTypeParsingData.parseParentName(signature.substring(secondCommaIndex + 2, thirdCommaIndex));
            int endIndex = signature.indexOf("]}", thirdCommaIndex + 3);
            int position = thirdCommaIndex + 3;
            ArrayList<QualifiedObjectName> otherAncestors = new ArrayList<QualifiedObjectName>();
            while (position < endIndex) {
                int nextPositionIndex = signature.indexOf(", ", position);
                if (nextPositionIndex == -1 || nextPositionIndex > endIndex) {
                    nextPositionIndex = endIndex;
                }
                otherAncestors.add(DistinctTypeParsingData.parseParentName(signature.substring(position, nextPositionIndex)).get());
                position = nextPositionIndex + 2;
            }
            return new DistinctTypeParsingData(endIndex + 1, new DistinctTypeInfo(name, baseType, topMostAncestor, otherAncestors, isOrderable));
        }
    }

    private static enum EnumMapParsingState {
        EXPECT_KEY,
        IN_KEY,
        IN_KEY_ESCAPE,
        EXPECT_COLON,
        EXPECT_VALUE,
        IN_NUM_VALUE,
        IN_STR_VALUE,
        IN_STR_VALUE_ESCAPE,
        EXPECT_COMMA_OR_CLOSING_BRACKET;

    }

    private static enum RowTypeSignatureParsingState {
        START_OF_FIELD,
        DELIMITED_NAME,
        DELIMITED_NAME_ESCAPED,
        TYPE_OR_NAMED_TYPE,
        TYPE,
        FINISHED;

    }
}

