/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.guava.util.concurrent;

import com.facebook.presto.jdbc.internal.guava.annotations.GwtIncompatible;
import com.facebook.presto.jdbc.internal.guava.annotations.J2ktIncompatible;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ExecutionError;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ParametricNullness;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.Platform;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.TimeLimiter;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    @CanIgnoreReturnValue
    public <T> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        return target;
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            Platform.restoreInterruptIfIsInterruptedException(e);
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        return this.callWithTimeout(callable, timeoutDuration, timeoutUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable2, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable2);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable2.run();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable2, long timeoutDuration, TimeUnit timeoutUnit) {
        this.runWithTimeout(runnable2, timeoutDuration, timeoutUnit);
    }
}

