/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.JoinType;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SpatialJoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<VariableReferenceExpression> outputVariables;
    private final RowExpression filter;
    private final Optional<VariableReferenceExpression> leftPartitionVariable;
    private final Optional<VariableReferenceExpression> rightPartitionVariable;
    private final Optional<String> kdbTree;
    private final DistributionType distributionType;

    @JsonCreator
    public SpatialJoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="filter") RowExpression filter, @JsonProperty(value="leftPartitionVariable") Optional<VariableReferenceExpression> leftPartitionVariable, @JsonProperty(value="rightPartitionVariable") Optional<VariableReferenceExpression> rightPartitionVariable, @JsonProperty(value="kdbTree") Optional<String> kdbTree) {
        this(sourceLocation, id, Optional.empty(), type, left, right, outputVariables, filter, leftPartitionVariable, rightPartitionVariable, kdbTree);
    }

    public SpatialJoinNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, Type type, PlanNode left, PlanNode right, List<VariableReferenceExpression> outputVariables, RowExpression filter, Optional<VariableReferenceExpression> leftPartitionVariable, Optional<VariableReferenceExpression> rightPartitionVariable, Optional<String> kdbTree) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.type = Objects.requireNonNull(type, "type is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
        this.outputVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputVariables, "outputVariables is null")));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.leftPartitionVariable = Objects.requireNonNull(leftPartitionVariable, "leftPartitionVariable is null");
        this.rightPartitionVariable = Objects.requireNonNull(rightPartitionVariable, "rightPartitionVariable is null");
        this.kdbTree = Objects.requireNonNull(kdbTree, "kdbTree is null");
        LinkedHashSet<VariableReferenceExpression> inputSymbols = new LinkedHashSet<VariableReferenceExpression>();
        inputSymbols.addAll(left.getOutputVariables());
        inputSymbols.addAll(right.getOutputVariables());
        Utils.checkArgument(inputSymbols.containsAll(outputVariables), "Left and right join inputs do not contain all output variables", new Object[0]);
        if (kdbTree.isPresent()) {
            Utils.checkArgument(leftPartitionVariable.isPresent(), "Left partition variable is missing", new Object[0]);
            Utils.checkArgument(rightPartitionVariable.isPresent(), "Right partition variable is missing", new Object[0]);
            Utils.checkArgument(left.getOutputVariables().contains(leftPartitionVariable.get()), "Left join input does not contain left partition variable", new Object[0]);
            Utils.checkArgument(right.getOutputVariables().contains(rightPartitionVariable.get()), "Right join input does not contain right partition variable", new Object[0]);
            this.distributionType = DistributionType.PARTITIONED;
        } else {
            Utils.checkArgument(!leftPartitionVariable.isPresent(), "KDB tree is missing", new Object[0]);
            Utils.checkArgument(!rightPartitionVariable.isPresent(), "KDB tree is missing", new Object[0]);
            this.distributionType = DistributionType.REPLICATED;
        }
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty
    public RowExpression getFilter() {
        return this.filter;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getLeftPartitionVariable() {
        return this.leftPartitionVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRightPartitionVariable() {
        return this.rightPartitionVariable;
    }

    @Override
    public List<PlanNode> getSources() {
        ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
        sources.add(this.left);
        sources.add(this.right);
        return Collections.unmodifiableList(sources);
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @JsonProperty
    public Optional<String> getKdbTree() {
        return this.kdbTree;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSpatialJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 2, "expected newChildren to contain 2 nodes", new Object[0]);
        return new SpatialJoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.type, newChildren.get(0), newChildren.get(1), this.outputVariables, this.filter, this.leftPartitionVariable, this.rightPartitionVariable, this.kdbTree);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new SpatialJoinNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.type, this.left, this.right, this.outputVariables, this.filter, this.leftPartitionVariable, this.rightPartitionVariable, this.kdbTree);
    }

    public static enum Type {
        INNER("SpatialInnerJoin"),
        LEFT("SpatialLeftJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public static Type fromJoinNodeType(JoinType joinNodeType) {
            switch (joinNodeType) {
                case INNER: {
                    return INNER;
                }
                case LEFT: {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)joinNodeType));
        }
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }
}

