/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.Subfield;
import com.facebook.presto.jdbc.internal.common.transaction.TransactionId;
import com.facebook.presto.jdbc.internal.spi.ColumnMetadata;
import com.facebook.presto.jdbc.internal.spi.security.AccessControl;
import com.facebook.presto.jdbc.internal.spi.security.AccessControlContext;
import com.facebook.presto.jdbc.internal.spi.security.DenyAllAccessControl;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import com.facebook.presto.jdbc.internal.spi.security.ViewExpression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ViewAccessControl
extends DenyAllAccessControl {
    private final AccessControl delegate;

    public ViewAccessControl(AccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<Subfield> columnOrSubfieldNames) {
        this.delegate.checkCanCreateViewWithSelectFromColumns(transactionId, identity, context, tableName, columnOrSubfieldNames.stream().map(Subfield::getRootName).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet)));
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        this.delegate.checkCanCreateViewWithSelectFromColumns(transactionId, identity, context, tableName, columnNames);
    }

    @Override
    public List<ViewExpression> getRowFilters(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        return this.delegate.getRowFilters(transactionId, identity, context, tableName);
    }

    @Override
    public Map<ColumnMetadata, ViewExpression> getColumnMasks(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, List<ColumnMetadata> columns) {
        return this.delegate.getColumnMasks(transactionId, identity, context, tableName, columns);
    }
}

