/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import java.util.Objects;
import java.util.Optional;

public class ViewExpression {
    private final String identity;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final String expression;

    public ViewExpression(String identity, Optional<String> catalog, Optional<String> schema, String expression) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        if (!catalog.isPresent() && schema.isPresent()) {
            throw new IllegalArgumentException("catalog must be present if schema is present");
        }
    }

    public String getIdentity() {
        return this.identity;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public String getExpression() {
        return this.expression;
    }
}

