/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.session;

import com.facebook.presto.jdbc.internal.common.type.BigintType;
import com.facebook.presto.jdbc.internal.common.type.BooleanType;
import com.facebook.presto.jdbc.internal.common.type.DoubleType;
import com.facebook.presto.jdbc.internal.common.type.IntegerType;
import com.facebook.presto.jdbc.internal.common.type.TinyintType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.VarcharType;
import com.facebook.presto.jdbc.internal.io.airlift.units.DataSize;
import com.facebook.presto.jdbc.internal.io.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.spi.session.SessionPropertyMetadata;
import java.util.Objects;
import java.util.function.Function;

public final class PropertyMetadata<T> {
    private final SessionPropertyMetadata sessionPropertyMetadata;
    private final Class<T> javaType;
    private final Type sqlType;
    private final T defaultValue;
    private final Function<Object, T> decoder;
    private final Function<T, Object> encoder;

    public PropertyMetadata(String name, String description, Type sqlType, Class<T> javaType, T defaultValue, boolean hidden, Function<Object, T> decoder, Function<T, Object> encoder) {
        this.sqlType = Objects.requireNonNull(sqlType, "sqlType is null");
        this.sessionPropertyMetadata = new SessionPropertyMetadata(name, description, sqlType.getTypeSignature(), defaultValue == null ? "" : defaultValue.toString(), hidden);
        this.javaType = Objects.requireNonNull(javaType, "javaType is null");
        this.defaultValue = defaultValue;
        this.decoder = Objects.requireNonNull(decoder, "decoder is null");
        this.encoder = Objects.requireNonNull(encoder, "encoder is null");
    }

    public String getName() {
        return this.sessionPropertyMetadata.getName();
    }

    public String getDescription() {
        return this.sessionPropertyMetadata.getDescription();
    }

    public Type getSqlType() {
        return this.sqlType;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isHidden() {
        return this.sessionPropertyMetadata.isHidden();
    }

    public T decode(Object value) {
        return this.decoder.apply(value);
    }

    public Function<Object, T> getDecoder() {
        return this.decoder;
    }

    public Object encode(T value) {
        return this.encoder.apply(value);
    }

    public Function<T, Object> getEncoder() {
        return this.encoder;
    }

    public static PropertyMetadata<Boolean> booleanProperty(String name, String description, Boolean defaultValue, boolean hidden) {
        return new PropertyMetadata<Boolean>(name, description, BooleanType.BOOLEAN, Boolean.class, defaultValue, hidden, Boolean.class::cast, object -> object);
    }

    public static PropertyMetadata<Integer> integerProperty(String name, String description, Integer defaultValue, boolean hidden) {
        return new PropertyMetadata<Integer>(name, description, IntegerType.INTEGER, Integer.class, defaultValue, hidden, value -> ((Number)value).intValue(), object -> object);
    }

    public static PropertyMetadata<Long> longProperty(String name, String description, Long defaultValue, boolean hidden) {
        return new PropertyMetadata<Long>(name, description, BigintType.BIGINT, Long.class, defaultValue, hidden, value -> ((Number)value).longValue(), object -> object);
    }

    public static PropertyMetadata<Byte> tinyIntProperty(String name, String description, Byte defaultValue, boolean hidden) {
        return new PropertyMetadata<Byte>(name, description, TinyintType.TINYINT, Byte.class, defaultValue, hidden, value -> ((Number)value).byteValue(), object -> object);
    }

    public static PropertyMetadata<Double> doubleProperty(String name, String description, Double defaultValue, boolean hidden) {
        return new PropertyMetadata<Double>(name, description, DoubleType.DOUBLE, Double.class, defaultValue, hidden, value -> ((Number)value).doubleValue(), object -> object);
    }

    public static PropertyMetadata<String> stringProperty(String name, String description, String defaultValue, boolean hidden) {
        return new PropertyMetadata<String>(name, description, VarcharType.VARCHAR, String.class, defaultValue, hidden, String.class::cast, object -> object);
    }

    public static PropertyMetadata<DataSize> dataSizeProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata<DataSize>(name, description, VarcharType.VARCHAR, DataSize.class, defaultValue, hidden, value -> DataSize.valueOf((String)value), DataSize::toString);
    }

    public static PropertyMetadata<Duration> durationProperty(String name, String description, Duration defaultValue, boolean hidden) {
        return new PropertyMetadata<Duration>(name, description, VarcharType.VARCHAR, Duration.class, defaultValue, hidden, value -> Duration.valueOf((String)value), Duration::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyMetadata)) {
            return false;
        }
        PropertyMetadata that = (PropertyMetadata)o;
        boolean isSessionPropertyMetadataEqual = this.sessionPropertyMetadata.equals(that.sessionPropertyMetadata);
        boolean isJavaTypeEqual = this.javaType.equals(that.javaType);
        boolean isDefaultValueEqual = this.defaultValue == null && that.defaultValue == null || this.defaultValue != null && this.defaultValue.equals(that.defaultValue);
        return isSessionPropertyMetadataEqual && isJavaTypeEqual && isDefaultValueEqual;
    }

    public int hashCode() {
        int result = this.sessionPropertyMetadata.hashCode();
        result = 31 * result + Objects.hashCode(this.javaType);
        result = 31 * result + Objects.hashCode(this.defaultValue);
        return result;
    }
}

