package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;

import com.facebook.presto.jdbc.internal.jackson.databind.*;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.NullValueProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;

public class ImmutableListDeserializer extends
    GuavaImmutableCollectionDeserializer<ImmutableList<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableListDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    public ImmutableListDeserializer withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableListDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }

    /*
    /**********************************************************
    /* Deserialization
    /**********************************************************
     */

    @Override
    protected ImmutableList.Builder<Object> createBuilder() {
        return ImmutableList.builder();
    }

    @Override
    protected ImmutableList<Object> _createEmpty(DeserializationContext ctxt) {
        return ImmutableList.of();
    }

    @Override
    protected ImmutableList<Object> _createWithSingleElement(DeserializationContext ctxt, Object value) {
        return ImmutableList.of(value);
    }
}
