/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.com.facebook.airlift.log;

import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.logging.Level;

public class Logger {
    private final java.util.logging.Logger logger;

    Logger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    public static Logger get(Class<?> clazz) {
        return Logger.get(clazz.getName());
    }

    public static Logger get(String name) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
        return new Logger(logger);
    }

    public void debug(Throwable exception, String message) {
        this.logger.log(Level.FINE, message, exception);
    }

    public void debug(String message) {
        this.logger.fine(message);
    }

    public void debug(String format, Object ... args2) {
        if (this.logger.isLoggable(Level.FINE)) {
            String message;
            try {
                message = String.format(format, args2);
            }
            catch (IllegalFormatException e) {
                this.logger.log(Level.SEVERE, this.illegalFormatMessageFor("DEBUG", format, args2), e);
                message = this.rawMessageFor(format, args2);
            }
            this.logger.fine(message);
        }
    }

    public void debug(Throwable exception, String format, Object ... args2) {
        if (this.logger.isLoggable(Level.FINE)) {
            String message;
            try {
                message = String.format(format, args2);
            }
            catch (IllegalFormatException e) {
                this.logger.log(Level.SEVERE, this.illegalFormatMessageFor("DEBUG", format, args2), e);
                message = this.rawMessageFor(format, args2);
            }
            this.logger.log(Level.FINE, message, exception);
        }
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String format, Object ... args2) {
        if (this.logger.isLoggable(Level.INFO)) {
            String message;
            try {
                message = String.format(format, args2);
            }
            catch (IllegalFormatException e) {
                this.logger.log(Level.SEVERE, this.illegalFormatMessageFor("INFO", format, args2), e);
                message = this.rawMessageFor(format, args2);
            }
            this.logger.info(message);
        }
    }

    public void warn(Throwable exception, String message) {
        this.logger.log(Level.WARNING, message, exception);
    }

    public void warn(String message) {
        this.logger.warning(message);
    }

    public void warn(Throwable exception, String format, Object ... args2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String message;
            try {
                message = String.format(format, args2);
            }
            catch (IllegalFormatException e) {
                this.logger.log(Level.SEVERE, this.illegalFormatMessageFor("WARN", format, args2), e);
                message = this.rawMessageFor(format, args2);
            }
            this.logger.log(Level.WARNING, message, exception);
        }
    }

    public void warn(String format, Object ... args2) {
        this.warn(null, format, args2);
    }

    public void error(Throwable exception, String message) {
        this.logger.log(Level.SEVERE, message, exception);
    }

    public void error(String message) {
        this.logger.severe(message);
    }

    public void error(Throwable exception, String format, Object ... args2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String message;
            try {
                message = String.format(format, args2);
            }
            catch (IllegalFormatException e) {
                this.logger.log(Level.SEVERE, this.illegalFormatMessageFor("ERROR", format, args2), e);
                message = this.rawMessageFor(format, args2);
            }
            this.logger.log(Level.SEVERE, message, exception);
        }
    }

    public void error(Throwable exception) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void error(String format, Object ... args2) {
        this.error(null, format, args2);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    private String illegalFormatMessageFor(String level, String message, Object ... args2) {
        return String.format("Invalid format string while trying to log: %s '%s' %s", level, message, Arrays.asList(args2));
    }

    private String rawMessageFor(String format, Object ... args2) {
        return String.format("'%s' %s", format, Arrays.asList(args2));
    }
}

