/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common;

import com.facebook.presto.jdbc.internal.common.SubfieldTokenizer;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Subfield {
    private final String name;
    private final List<PathElement> path;

    public static PathElement allSubscripts() {
        return AllSubscripts.getInstance();
    }

    public static PathElement noSubfield() {
        return NoSubfield.getInstance();
    }

    @JsonCreator
    public Subfield(String path) {
        Objects.requireNonNull(path, "path is null");
        SubfieldTokenizer tokenizer = new SubfieldTokenizer(path);
        Subfield.checkArgument(tokenizer.hasNext(), "Column name is missing: " + path);
        PathElement firstElement = tokenizer.next();
        Subfield.checkArgument(firstElement instanceof NestedField, "Subfield path must start with a name: " + path);
        this.name = ((NestedField)firstElement).getName();
        ArrayList pathElements = new ArrayList();
        tokenizer.forEachRemaining(pathElements::add);
        this.path = Collections.unmodifiableList(pathElements);
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public Subfield(String name, List<PathElement> path) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.path = Objects.requireNonNull(path, "path is null");
    }

    public String getRootName() {
        return this.name;
    }

    public List<PathElement> getPath() {
        return this.path;
    }

    public boolean isPrefix(Subfield other) {
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (this.path.size() < other.path.size()) {
            return Objects.equals(this.path, other.path.subList(0, this.path.size()));
        }
        return false;
    }

    public Subfield tail(String name) {
        if (this.path.isEmpty()) {
            throw new IllegalStateException("path is empty");
        }
        return new Subfield(name, this.path.subList(1, this.path.size()));
    }

    @JsonValue
    public String serialize() {
        return this.name + this.path.stream().map(Object::toString).collect(Collectors.joining());
    }

    public String toString() {
        return this.serialize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subfield other = (Subfield)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.path, other.path);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path);
    }

    public static final class AllSubscripts
    implements PathElement {
        private static final AllSubscripts ALL_SUBSCRIPTS = new AllSubscripts();

        private AllSubscripts() {
        }

        public static AllSubscripts getInstance() {
            return ALL_SUBSCRIPTS;
        }

        @Override
        public boolean isSubscript() {
            return true;
        }

        public String toString() {
            return "[*]";
        }
    }

    public static final class NoSubfield
    implements PathElement {
        private static final NoSubfield NO_SUBFIELD = new NoSubfield();

        private NoSubfield() {
        }

        public static NoSubfield getInstance() {
            return NO_SUBFIELD;
        }

        @Override
        public boolean isSubscript() {
            return false;
        }

        public String toString() {
            return ".$";
        }
    }

    public static interface PathElement {
        public boolean isSubscript();
    }

    public static final class NestedField
    implements PathElement {
        private final String name;

        public NestedField(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedField that = (NestedField)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "." + this.name;
        }

        @Override
        public boolean isSubscript() {
            return false;
        }
    }

    public static final class StringSubscript
    implements PathElement {
        private final String index;

        public StringSubscript(String index) {
            this.index = Objects.requireNonNull(index, "index is null");
        }

        public String getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringSubscript that = (StringSubscript)o;
            return Objects.equals(this.index, that.index);
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public String toString() {
            return "[\"" + this.index.replace("\"", "\\\"") + "\"]";
        }

        @Override
        public boolean isSubscript() {
            return true;
        }
    }

    public static final class LongSubscript
    implements PathElement {
        private final long index;

        public LongSubscript(long index) {
            this.index = index;
        }

        public long getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongSubscript that = (LongSubscript)o;
            return this.index == that.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public String toString() {
            return "[" + this.index + "]";
        }

        @Override
        public boolean isSubscript() {
            return true;
        }
    }
}

