/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.common.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.common.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.common.block.ShortArrayBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;

public class ShortArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "SHORT_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        boolean mayHaveNull = block.mayHaveNull();
        for (int position = 0; position < positionCount; ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            sliceOutput.writeShort(block.getShort(position));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        short[] values2 = new short[positionCount];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedShortArray(values2));
        } else {
            for (int position = 0; position < values2.length; ++position) {
                if (valueIsNull[position]) continue;
                values2[position] = sliceInput.readShort();
            }
        }
        return new ShortArrayBlock(0, positionCount, valueIsNull, values2);
    }
}

