/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.BigintEnumType;
import com.facebook.presto.jdbc.internal.common.type.DistinctTypeInfo;
import com.facebook.presto.jdbc.internal.common.type.NamedTypeSignature;
import com.facebook.presto.jdbc.internal.common.type.ParameterKind;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.VarcharEnumType;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftUnion;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftUnionId;
import java.util.Objects;

@ThriftUnion
public class TypeSignatureParameterUnion {
    private TypeSignature typeSignature;
    private Long longLiteral;
    private NamedTypeSignature namedTypeSignature;
    private String variable;
    private BigintEnumType.LongEnumMap longEnumMap;
    private VarcharEnumType.VarcharEnumMap varcharEnumMap;
    private DistinctTypeInfo distinctTypeInfo;
    private final short id;

    @ThriftConstructor
    public TypeSignatureParameterUnion(TypeSignature typeSignature) {
        this.typeSignature = typeSignature;
        this.id = (short)ParameterKind.TYPE.getValue();
    }

    @ThriftField(value=1)
    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    @ThriftConstructor
    public TypeSignatureParameterUnion(NamedTypeSignature namedTypeSignature) {
        this.namedTypeSignature = namedTypeSignature;
        this.id = (short)ParameterKind.NAMED_TYPE.getValue();
    }

    @ThriftField(value=2)
    public NamedTypeSignature getNamedTypeSignature() {
        return this.namedTypeSignature;
    }

    @ThriftConstructor
    public TypeSignatureParameterUnion(Long longLiteral) {
        this.longLiteral = longLiteral;
        this.id = (short)ParameterKind.LONG.getValue();
    }

    @ThriftField(value=3)
    public Long getLongLiteral() {
        return this.longLiteral;
    }

    @ThriftConstructor
    public TypeSignatureParameterUnion(String variable) {
        this.variable = variable;
        this.id = (short)ParameterKind.VARIABLE.getValue();
    }

    @ThriftField(value=4)
    public String getVariable() {
        return this.variable;
    }

    @ThriftConstructor
    public TypeSignatureParameterUnion(BigintEnumType.LongEnumMap longEnumMap) {
        this.longEnumMap = longEnumMap;
        this.id = (short)ParameterKind.LONG_ENUM.getValue();
    }

    @ThriftField(value=5)
    public BigintEnumType.LongEnumMap getLongEnumMap() {
        return this.longEnumMap;
    }

    @ThriftConstructor
    public TypeSignatureParameterUnion(VarcharEnumType.VarcharEnumMap varcharEnumMap) {
        this.varcharEnumMap = varcharEnumMap;
        this.id = (short)ParameterKind.VARCHAR_ENUM.getValue();
    }

    @ThriftField(value=6)
    public VarcharEnumType.VarcharEnumMap getVarcharEnumMap() {
        return this.varcharEnumMap;
    }

    @ThriftConstructor
    public TypeSignatureParameterUnion(DistinctTypeInfo distinctTypeInfo) {
        this.distinctTypeInfo = distinctTypeInfo;
        this.id = (short)ParameterKind.DISTINCT_TYPE.getValue();
    }

    @ThriftField(value=7)
    public DistinctTypeInfo getDistinctTypeInfo() {
        return this.distinctTypeInfo;
    }

    @ThriftUnionId
    public short getId() {
        return this.id;
    }

    public static TypeSignatureParameterUnion convertToTypeSignatureParameterUnion(Object value) {
        if (value instanceof TypeSignature) {
            return new TypeSignatureParameterUnion((TypeSignature)value);
        }
        if (value instanceof Long) {
            return new TypeSignatureParameterUnion((Long)value);
        }
        if (value instanceof NamedTypeSignature) {
            return new TypeSignatureParameterUnion((NamedTypeSignature)value);
        }
        if (value instanceof String) {
            return new TypeSignatureParameterUnion((String)value);
        }
        if (value instanceof BigintEnumType.LongEnumMap) {
            return new TypeSignatureParameterUnion((BigintEnumType.LongEnumMap)value);
        }
        if (value instanceof VarcharEnumType.VarcharEnumMap) {
            return new TypeSignatureParameterUnion((VarcharEnumType.VarcharEnumMap)value);
        }
        if (value instanceof DistinctTypeInfo) {
            return new TypeSignatureParameterUnion((DistinctTypeInfo)value);
        }
        throw new IllegalArgumentException("value is of an unknown type: " + value.getClass().getName());
    }

    public static Object convertToValue(TypeSignatureParameterUnion parameterUnion) {
        if (parameterUnion.getTypeSignature() != null) {
            return parameterUnion.getTypeSignature();
        }
        if (parameterUnion.getLongLiteral() != null) {
            return parameterUnion.getLongLiteral();
        }
        if (parameterUnion.getNamedTypeSignature() != null) {
            return parameterUnion.getNamedTypeSignature();
        }
        if (parameterUnion.getVariable() != null) {
            return parameterUnion.getVariable();
        }
        if (parameterUnion.getLongEnumMap() != null) {
            return parameterUnion.getLongEnumMap();
        }
        if (parameterUnion.getVarcharEnumMap() != null) {
            return parameterUnion.getVarcharEnumMap();
        }
        if (parameterUnion.getDistinctTypeInfo() != null) {
            return parameterUnion.getDistinctTypeInfo();
        }
        throw new IllegalArgumentException("TypeSignatureParameterUnion is of an unknown type: " + parameterUnion.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSignatureParameterUnion other = (TypeSignatureParameterUnion)o;
        return Objects.equals(this.typeSignature, other.typeSignature) && Objects.equals(this.longLiteral, other.longLiteral) && Objects.equals(this.namedTypeSignature, other.namedTypeSignature) && Objects.equals(this.variable, other.variable) && Objects.equals(this.longEnumMap, other.longEnumMap) && Objects.equals(this.varcharEnumMap, other.varcharEnumMap) && Objects.equals(this.distinctTypeInfo, other.distinctTypeInfo) && Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.typeSignature, this.longLiteral, this.namedTypeSignature, this.variable, this.longEnumMap, this.varcharEnumMap, this.distinctTypeInfo, this.id);
    }
}

