/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.common.predicate.NullableValue;
import com.facebook.presto.jdbc.internal.common.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class Constraint<T> {
    private final TupleDomain<T> summary;
    private final Optional<Predicate<Map<T, NullableValue>>> predicate;
    private final Optional<List<T>> predicateInputs;

    public static <V> Constraint<V> alwaysTrue() {
        return new Constraint(TupleDomain.all(), Optional.empty());
    }

    public static <V> Constraint<V> alwaysFalse() {
        return new Constraint(TupleDomain.none(), Optional.of(bindings -> false));
    }

    public Constraint(TupleDomain<T> summary) {
        this(summary, Optional.empty());
    }

    public Constraint(TupleDomain<T> summary, Predicate<Map<T, NullableValue>> predicate) {
        this(summary, Optional.of(predicate));
    }

    public Constraint(TupleDomain<T> summary, Optional<Predicate<Map<T, NullableValue>>> predicate) {
        this(summary, predicate, Optional.empty());
    }

    public Constraint(TupleDomain<T> summary, Optional<Predicate<Map<T, NullableValue>>> predicate, Optional<List<T>> predicateInputs) {
        Objects.requireNonNull(summary, "summary is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(predicateInputs, "predicateInputs is null");
        this.summary = summary;
        this.predicate = predicate;
        this.predicateInputs = predicateInputs;
    }

    public TupleDomain<T> getSummary() {
        return this.summary;
    }

    public Optional<Predicate<Map<T, NullableValue>>> predicate() {
        return this.predicate;
    }

    public Optional<List<T>> getPredicateInputs() {
        return this.predicateInputs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Constraint)) {
            return false;
        }
        Constraint other = (Constraint)obj;
        return this.summary.equals(other.summary) && this.predicate.equals(other.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.summary, this.predicate);
    }
}

