/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableHandle;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JoinTableInfo {
    private final ConnectorTableHandle tableHandle;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final List<VariableReferenceExpression> outputVariables;

    public JoinTableInfo(ConnectorTableHandle tableHandle, Map<VariableReferenceExpression, ColumnHandle> assignments, List<VariableReferenceExpression> outputVariables) {
        this.tableHandle = tableHandle;
        this.assignments = Collections.unmodifiableMap(assignments);
        this.outputVariables = Collections.unmodifiableList(outputVariables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JoinTableInfo o = (JoinTableInfo)obj;
        return Objects.equals(this.tableHandle, o.tableHandle) && Objects.equals(this.assignments, o.assignments) && Objects.equals(this.outputVariables, o.outputVariables);
    }

    public int hashCode() {
        return Objects.hash(this.tableHandle, this.assignments, this.outputVariables);
    }

    public ConnectorTableHandle getTableHandle() {
        return this.tableHandle;
    }

    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }
}

