/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.analyzer;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.Subfield;
import com.facebook.presto.jdbc.internal.spi.MaterializedViewDefinition;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlInfo;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlInfoForTable;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlRole;
import com.facebook.presto.jdbc.internal.spi.analyzer.ViewDefinition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AccessControlReferences {
    private final Map<AccessControlRole, Set<AccessControlInfoForTable>> tableReferences = new LinkedHashMap<AccessControlRole, Set<AccessControlInfoForTable>>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> tableColumnAndSubfieldReferencesForAccessControl = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>>();
    private AccessControlInfo queryAccessControlInfo;
    private final Map<QualifiedObjectName, ViewDefinition> viewDefinitions = new LinkedHashMap<QualifiedObjectName, ViewDefinition>();
    private final Map<QualifiedObjectName, MaterializedViewDefinition> materializedViewDefinitions = new LinkedHashMap<QualifiedObjectName, MaterializedViewDefinition>();

    public Map<AccessControlRole, Set<AccessControlInfoForTable>> getTableReferences() {
        return Collections.unmodifiableMap(this.tableReferences);
    }

    public void addTableReference(AccessControlRole role, AccessControlInfoForTable accessControlInfoForTable) {
        this.tableReferences.computeIfAbsent(role, r -> new LinkedHashSet()).add(accessControlInfoForTable);
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> getTableColumnAndSubfieldReferencesForAccessControl() {
        return this.tableColumnAndSubfieldReferencesForAccessControl;
    }

    public void addTableColumnAndSubfieldReferencesForAccessControl(Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> tableColumnAndSubfieldReferencesForAccessControl) {
        this.tableColumnAndSubfieldReferencesForAccessControl.putAll(Objects.requireNonNull(tableColumnAndSubfieldReferencesForAccessControl, "tableColumnAndSubfieldReferencesForAccessControl is null"));
    }

    public void setQueryAccessControlInfo(AccessControlInfo queryAccessControlInfo) {
        if (this.queryAccessControlInfo == null) {
            this.queryAccessControlInfo = Objects.requireNonNull(queryAccessControlInfo, "queryAccessControlInfo is null");
        }
    }

    public AccessControlInfo getQueryAccessControlInfo() {
        return this.queryAccessControlInfo;
    }

    public void addViewDefinitionReference(QualifiedObjectName viewDefinitionName, ViewDefinition viewDefinition) {
        this.viewDefinitions.put(viewDefinitionName, viewDefinition);
    }

    public void addMaterializedViewDefinitionReference(QualifiedObjectName viewDefinitionName, MaterializedViewDefinition materializedViewDefinition) {
        this.materializedViewDefinitions.put(viewDefinitionName, materializedViewDefinition);
    }

    public Map<QualifiedObjectName, ViewDefinition> getViewDefinitions() {
        return Collections.unmodifiableMap(new LinkedHashMap<QualifiedObjectName, ViewDefinition>(this.viewDefinitions));
    }

    public Map<QualifiedObjectName, MaterializedViewDefinition> getMaterializedViewDefinitions() {
        return Collections.unmodifiableMap(new LinkedHashMap<QualifiedObjectName, MaterializedViewDefinition>(this.materializedViewDefinitions));
    }
}

