/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonIgnore;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandle;
import com.facebook.presto.jdbc.internal.spi.function.FunctionHandleResolver;
import com.facebook.presto.jdbc.internal.spi.function.Signature;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunctionHandle;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunctionId;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RestFunctionHandle
extends SqlFunctionHandle {
    private final Signature signature;
    private final Optional<URI> executionEndpoint;

    @JsonCreator
    public RestFunctionHandle(@JsonProperty(value="functionId") SqlFunctionId functionId, @JsonProperty(value="version") String version, @JsonProperty(value="signature") Signature signature, @JsonProperty(value="executionEndpoint") Optional<URI> executionEndpoint) {
        super(functionId, version);
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.executionEndpoint = Objects.requireNonNull(executionEndpoint, "executionEndpoint is null");
        executionEndpoint.ifPresent(uri -> {
            String scheme = uri.getScheme();
            if (!"http".equals(scheme) && !"https".equals(scheme)) {
                throw new IllegalArgumentException("Execution endpoint must use HTTP or HTTPS protocol: " + uri);
            }
        });
    }

    public RestFunctionHandle(SqlFunctionId functionId, String version, Signature signature) {
        this(functionId, version, signature, Optional.empty());
    }

    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    @JsonProperty
    public Optional<URI> getExecutionEndpoint() {
        return this.executionEndpoint;
    }

    @Override
    @JsonIgnore
    public List<TypeSignature> getArgumentTypes() {
        return super.getArgumentTypes();
    }

    public static class Resolver
    implements FunctionHandleResolver {
        @Override
        public Class<? extends FunctionHandle> getFunctionHandleClass() {
            return RestFunctionHandle.class;
        }
    }
}

