/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function.aggregation;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.function.AccumulatorStateFactory;
import com.facebook.presto.jdbc.internal.spi.function.AccumulatorStateSerializer;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AggregationMetadata {
    public static final Set<Class<?>> SUPPORTED_PARAMETER_TYPES = new HashSet<Class>(Arrays.asList(Block.class, Long.TYPE, Double.TYPE, Boolean.TYPE, Slice.class));
    private final String name;
    private final List<ParameterMetadata> valueInputMetadata;
    private final List<Class> lambdaInterfaces;
    private final MethodHandle inputFunction;
    private final MethodHandle combineFunction;
    private final MethodHandle outputFunction;
    private final List<AccumulatorStateDescriptor> accumulatorStateDescriptors;
    private final Type outputType;

    public AggregationMetadata(String name, List<ParameterMetadata> valueInputMetadata, MethodHandle inputFunction, MethodHandle combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor> accumulatorStateDescriptors, Type outputType) {
        this(name, valueInputMetadata, inputFunction, combineFunction, outputFunction, accumulatorStateDescriptors, outputType, Collections.emptyList());
    }

    public AggregationMetadata(String name, List<ParameterMetadata> valueInputMetadata, MethodHandle inputFunction, MethodHandle combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor> accumulatorStateDescriptors, Type outputType, List<Class> lambdaInterfaces) {
        this.outputType = Objects.requireNonNull(outputType);
        this.valueInputMetadata = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(valueInputMetadata, "valueInputMetadata is null")));
        this.name = Objects.requireNonNull(name, "name is null");
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction is null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction is null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction is null");
        this.accumulatorStateDescriptors = Objects.requireNonNull(accumulatorStateDescriptors, "accumulatorStateDescriptors is null");
        this.lambdaInterfaces = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null")));
        AggregationMetadata.verifyInputFunctionSignature(inputFunction, valueInputMetadata, lambdaInterfaces, accumulatorStateDescriptors);
        AggregationMetadata.verifyCombineFunction(combineFunction, lambdaInterfaces, accumulatorStateDescriptors);
        AggregationMetadata.verifyExactOutputFunction(outputFunction, accumulatorStateDescriptors);
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<ParameterMetadata> getValueInputMetadata() {
        return this.valueInputMetadata;
    }

    public List<Class> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public String getName() {
        return this.name;
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public MethodHandle getCombineFunction() {
        return this.combineFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public List<AccumulatorStateDescriptor> getAccumulatorStateDescriptors() {
        return this.accumulatorStateDescriptors;
    }

    private static void verifyInputFunctionSignature(MethodHandle method, List<ParameterMetadata> dataChannelMetadata, List<Class> lambdaInterfaces, List<AccumulatorStateDescriptor> stateDescriptors) {
        int i;
        Class<?>[] parameters = method.type().parameterArray();
        AggregationMetadata.checkArgument(parameters.length > 0, "Aggregation input function must have at least one parameter", new Object[0]);
        AggregationMetadata.checkArgument(parameters.length == dataChannelMetadata.size() + lambdaInterfaces.size(), String.format("Number of parameters in input function (%d) must be the total number of data channels and lambda channels (%d)", parameters.length, dataChannelMetadata.size() + lambdaInterfaces.size()), new Object[0]);
        AggregationMetadata.checkArgument(dataChannelMetadata.stream().filter(m -> m.getParameterType() == ParameterMetadata.ParameterType.STATE).count() == (long)stateDescriptors.size(), "Number of state parameter in input function must be the same as size of stateDescriptors", new Object[0]);
        AggregationMetadata.checkArgument(dataChannelMetadata.get(0).getParameterType() == ParameterMetadata.ParameterType.STATE, "First parameter must be state", new Object[0]);
        int stateIndex = 0;
        block6: for (i = 0; i < dataChannelMetadata.size(); ++i) {
            ParameterMetadata metadata = dataChannelMetadata.get(i);
            switch (metadata.getParameterType()) {
                case STATE: {
                    AggregationMetadata.checkArgument(stateDescriptors.get(stateIndex).getStateInterface() == parameters[i], String.format("State argument must be of type %s, found %s", stateDescriptors.get(stateIndex).getStateInterface(), parameters[i]), new Object[0]);
                    ++stateIndex;
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    AggregationMetadata.checkArgument(parameters[i] == Block.class, "Parameter must be Block if it has @BlockPosition", new Object[0]);
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    AggregationMetadata.checkArgument(SUPPORTED_PARAMETER_TYPES.contains(parameters[i]), "Unsupported type: %s", parameters[i].getSimpleName());
                    AggregationMetadata.verifyMethodParameterType(method, i, metadata.getSqlType().getJavaType(), metadata.getSqlType().getDisplayName());
                    continue block6;
                }
                case BLOCK_INDEX: {
                    AggregationMetadata.checkArgument(parameters[i] == Integer.TYPE, "Block index parameter must be an int", new Object[0]);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter: " + (Object)((Object)metadata.getParameterType()));
                }
            }
        }
        AggregationMetadata.checkArgument(stateIndex == stateDescriptors.size(), String.format("Input function only has %d states, expected: %d.", stateIndex, stateDescriptors.size()), new Object[0]);
        for (i = 0; i < lambdaInterfaces.size(); ++i) {
            AggregationMetadata.verifyMethodParameterType(method, i + dataChannelMetadata.size(), lambdaInterfaces.get(i), "function");
        }
    }

    private static void verifyCombineFunction(MethodHandle method, List<Class> lambdaInterfaces, List<AccumulatorStateDescriptor> stateDescriptors) {
        int i;
        Class<?>[] parameterTypes = method.type().parameterArray();
        AggregationMetadata.checkArgument(parameterTypes.length == stateDescriptors.size() * 2 + lambdaInterfaces.size(), "Number of arguments for combine function must be 2 times the size of states plus number of lambda channels.", new Object[0]);
        for (i = 0; i < stateDescriptors.size() * 2; ++i) {
            AggregationMetadata.checkArgument(parameterTypes[i].equals(stateDescriptors.get(i % stateDescriptors.size()).getStateInterface()), String.format("Type for Parameter index %d is unexpected. Arguments for combine function must appear in the order of state1, state2, ..., otherState1, otherState2, ...", i), new Object[0]);
        }
        for (i = 0; i < lambdaInterfaces.size(); ++i) {
            AggregationMetadata.verifyMethodParameterType(method, i + stateDescriptors.size() * 2, lambdaInterfaces.get(i), "function");
        }
    }

    private static void verifyExactOutputFunction(MethodHandle method, List<AccumulatorStateDescriptor> stateDescriptors) {
        if (method == null) {
            return;
        }
        Class<?>[] parameterTypes = method.type().parameterArray();
        AggregationMetadata.checkArgument(parameterTypes.length == stateDescriptors.size() + 1, "Number of arguments for output function must be exactly one plus than number of states.", new Object[0]);
        for (int i = 0; i < stateDescriptors.size(); ++i) {
            AggregationMetadata.checkArgument(parameterTypes[i].equals(stateDescriptors.get(i).getStateInterface()), String.format("Type for Parameter index %d is unexpected", i), new Object[0]);
        }
        AggregationMetadata.checkArgument(Arrays.stream(parameterTypes).filter(type -> type.equals(BlockBuilder.class)).count() == 1L, "Output function must take exactly one BlockBuilder parameter", new Object[0]);
    }

    private static void verifyMethodParameterType(MethodHandle method, int index, Class javaType, String sqlTypeDisplayName) {
        AggregationMetadata.checkArgument(method.type().parameterArray()[index] == javaType, "Expected method %s parameter %s type to be %s (%s)", method, index, javaType.getName(), sqlTypeDisplayName);
    }

    public static int countInputChannels(List<ParameterMetadata> metadatas) {
        int parameters = 0;
        for (ParameterMetadata metadata : metadatas) {
            if (metadata.getParameterType() != ParameterMetadata.ParameterType.INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL) continue;
            ++parameters;
        }
        return parameters;
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }

    public static class ParameterMetadata {
        private final ParameterType parameterType;
        private final Type sqlType;

        public ParameterMetadata(ParameterType parameterType) {
            this(parameterType, null);
        }

        public ParameterMetadata(ParameterType parameterType, Type sqlType) {
            AggregationMetadata.checkArgument(sqlType == null == (parameterType == ParameterType.BLOCK_INDEX || parameterType == ParameterType.STATE), "sqlType must be provided only for input channels", new Object[0]);
            this.parameterType = parameterType;
            this.sqlType = sqlType;
        }

        public static ParameterMetadata fromSqlType(Type sqlType, boolean isBlock, boolean isNullable, String methodName) {
            return new ParameterMetadata(ParameterType.inputChannelParameterType(isNullable, isBlock, methodName), sqlType);
        }

        public static ParameterMetadata forBlockIndexParameter() {
            return new ParameterMetadata(ParameterType.BLOCK_INDEX);
        }

        public static ParameterMetadata forStateParameter() {
            return new ParameterMetadata(ParameterType.STATE);
        }

        public ParameterType getParameterType() {
            return this.parameterType;
        }

        public Type getSqlType() {
            return this.sqlType;
        }

        public static enum ParameterType {
            INPUT_CHANNEL,
            BLOCK_INPUT_CHANNEL,
            NULLABLE_BLOCK_INPUT_CHANNEL,
            BLOCK_INDEX,
            STATE;


            public static ParameterType inputChannelParameterType(boolean isNullable, boolean isBlock, String methodName) {
                if (isBlock) {
                    if (isNullable) {
                        return NULLABLE_BLOCK_INPUT_CHANNEL;
                    }
                    return BLOCK_INPUT_CHANNEL;
                }
                if (isNullable) {
                    throw new IllegalArgumentException(methodName + " contains a parameter with @NullablePosition that is not @BlockPosition");
                }
                return INPUT_CHANNEL;
            }
        }
    }

    public static class AccumulatorStateDescriptor {
        private final Class<?> stateInterface;
        private final AccumulatorStateSerializer<?> serializer;
        private final AccumulatorStateFactory<?> factory;

        public AccumulatorStateDescriptor(Class<?> stateInterface, AccumulatorStateSerializer<?> serializer, AccumulatorStateFactory<?> factory2) {
            this.stateInterface = Objects.requireNonNull(stateInterface, "stateInterface is null");
            this.serializer = Objects.requireNonNull(serializer, "serializer is null");
            this.factory = Objects.requireNonNull(factory2, "factory is null");
        }

        public Class<?> getStateInterface() {
            return this.stateInterface;
        }

        public AccumulatorStateSerializer<?> getSerializer() {
            return this.serializer;
        }

        public AccumulatorStateFactory<?> getFactory() {
            return this.factory;
        }
    }
}

