/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.plan.OrderingScheme;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class DataOrganizationSpecification {
    private final List<VariableReferenceExpression> partitionBy;
    private final Optional<OrderingScheme> orderingScheme;

    @JsonCreator
    public DataOrganizationSpecification(@JsonProperty(value="partitionBy") List<VariableReferenceExpression> partitionBy, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
        Objects.requireNonNull(partitionBy, "partitionBy is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.partitionBy = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(partitionBy));
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
    }

    @JsonProperty
    public List<VariableReferenceExpression> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    public int hashCode() {
        return Objects.hash(this.partitionBy, this.orderingScheme);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataOrganizationSpecification other = (DataOrganizationSpecification)obj;
        return Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderingScheme, other.orderingScheme);
    }
}

