/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.EquiJoinClause;
import com.facebook.presto.jdbc.internal.spi.plan.JoinType;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class MergeJoinNode
extends PlanNode {
    private final JoinType type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final Optional<RowExpression> filter;
    private final List<VariableReferenceExpression> outputVariables;
    private final Optional<VariableReferenceExpression> leftHashVariable;
    private final Optional<VariableReferenceExpression> rightHashVariable;

    @JsonCreator
    public MergeJoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") JoinType type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="filter") Optional<RowExpression> filter, @JsonProperty(value="leftHashVariable") Optional<VariableReferenceExpression> leftHashVariable, @JsonProperty(value="rightHashVariable") Optional<VariableReferenceExpression> rightHashVariable) {
        this(sourceLocation, id, Optional.empty(), type, left, right, criteria, outputVariables, filter, leftHashVariable, rightHashVariable);
    }

    public MergeJoinNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.type = Objects.requireNonNull(type, "type is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
        this.criteria = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(criteria, "criteria is null")));
        this.outputVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputVariables, "outputVariables is null")));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.leftHashVariable = Objects.requireNonNull(leftHashVariable, "leftHashVariable is null");
        this.rightHashVariable = Objects.requireNonNull(rightHashVariable, "rightHashVariable is null");
    }

    @JsonProperty
    public JoinType getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Optional<RowExpression> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getLeftHashVariable() {
        return this.leftHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRightHashVariable() {
        return this.rightHashVariable;
    }

    @Override
    public List<PlanNode> getSources() {
        ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
        sources.add(this.left);
        sources.add(this.right);
        return Collections.unmodifiableList(sources);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 2, "expected newChildren to contain 2 nodes", new Object[0]);
        return new MergeJoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new MergeJoinNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.type, this.left, this.right, this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMergeJoin(this, context);
    }
}

