/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.TableHandle;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class MetadataDeleteNode
extends PlanNode {
    private final TableHandle tableHandle;
    private final VariableReferenceExpression output;

    @JsonCreator
    public MetadataDeleteNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="target") TableHandle tableHandle, @JsonProperty(value="output") VariableReferenceExpression output) {
        this(sourceLocation, id, Optional.empty(), tableHandle, output);
    }

    public MetadataDeleteNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, TableHandle tableHandle, VariableReferenceExpression output) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.tableHandle = Objects.requireNonNull(tableHandle, "target is null");
        this.output = Objects.requireNonNull(output, "output is null");
    }

    @JsonProperty
    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public VariableReferenceExpression getOutput() {
        return this.output;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return Collections.singletonList(this.output);
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMetadataDelete(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new MetadataDeleteNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.tableHandle, this.output);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new MetadataDeleteNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.tableHandle, this.output);
    }
}

