/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.common.Utils;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class UnnestNode
extends PlanNode {
    private final PlanNode source;
    private final List<VariableReferenceExpression> replicateVariables;
    private final Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables;
    private final Optional<VariableReferenceExpression> ordinalityVariable;

    @JsonCreator
    public UnnestNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source2, @JsonProperty(value="replicateVariables") List<VariableReferenceExpression> replicateVariables, @JsonProperty(value="unnestVariables") Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables, @JsonProperty(value="ordinalityVariable") Optional<VariableReferenceExpression> ordinalityVariable) {
        this(sourceLocation, id, Optional.empty(), source2, replicateVariables, unnestVariables, ordinalityVariable);
    }

    public UnnestNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source2, List<VariableReferenceExpression> replicateVariables, Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables, Optional<VariableReferenceExpression> ordinalityVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source2, "source is null");
        this.replicateVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(replicateVariables, "replicateVariables is null")));
        Utils.checkArgument(source2.getOutputVariables().containsAll(replicateVariables), "Source does not contain all replicateSymbols", new Object[0]);
        Objects.requireNonNull(unnestVariables, "unnestVariables is null");
        Utils.checkArgument(!unnestVariables.isEmpty(), "unnestVariables is empty", new Object[0]);
        LinkedHashMap unnestVariablesMap = new LinkedHashMap();
        for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : unnestVariables.entrySet()) {
            unnestVariablesMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
        }
        this.unnestVariables = Collections.unmodifiableMap(unnestVariablesMap);
        this.ordinalityVariable = Objects.requireNonNull(ordinalityVariable, "ordinalityVariable is null");
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        ArrayList<VariableReferenceExpression> outputSymbols = new ArrayList<VariableReferenceExpression>(this.replicateVariables);
        this.unnestVariables.values().forEach(outputSymbols::addAll);
        this.ordinalityVariable.ifPresent(outputSymbols::add);
        return Collections.unmodifiableList(outputSymbols);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getReplicateVariables() {
        return this.replicateVariables;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, List<VariableReferenceExpression>> getUnnestVariables() {
        return this.unnestVariables;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getOrdinalityVariable() {
        return this.ordinalityVariable;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument(newChildren.size() == 1);
        return new UnnestNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new UnnestNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnnestNode that = (UnnestNode)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.replicateVariables, that.replicateVariables) && Objects.equals(this.unnestVariables, that.unnestVariables) && Objects.equals(this.ordinalityVariable, that.ordinalityVariable);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }

    public String toString() {
        return String.format("%s {source=%s, replicateVariables=%s, unnestVariables=%s, ordinalityVariable=%s}", this.getClass().getSimpleName(), this.source, this.replicateVariables, this.unnestVariables, this.ordinalityVariable);
    }
}

