/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.resourceGroups;

import com.facebook.presto.jdbc.internal.spi.session.ResourceEstimates;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SelectionCriteria {
    private final boolean authenticated;
    private final String user;
    private final Optional<String> source;
    private final Set<String> clientTags;
    private final ResourceEstimates resourceEstimates;
    private final Optional<String> queryType;
    private final Optional<String> clientInfo;
    private final Optional<String> schema;
    private final Optional<String> principal;

    public SelectionCriteria(boolean authenticated, String user, Optional<String> source2, Set<String> clientTags, ResourceEstimates resourceEstimates, Optional<String> queryType, Optional<String> clientInfo, Optional<String> schema, Optional<String> principal) {
        this.authenticated = authenticated;
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = Objects.requireNonNull(source2, "source is null");
        this.clientTags = Collections.unmodifiableSet(Objects.requireNonNull(clientTags, "tags is null"));
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Set<String> getTags() {
        return this.clientTags;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<String> getPrincipal() {
        return this.principal;
    }
}

